/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.reload;

public class SpringReloadConfig {
    private static final String SPRING_RELOAD_DELAY_MILLIS = "SpringReloadDelayMillis";
    private static final String SPRING_TEST_SLEEP_TIME_FACTOR = "SpringTestSleepTimeFactor";
    public static int reloadDelayMillis;
    private static boolean isReloadDelayMillisProperty;
    private static double testSleepTimeFactor;

    public static void setDelayMillis(int delayMillis) {
        if (isReloadDelayMillisProperty) {
            return;
        }
        if (delayMillis > 30000) {
            reloadDelayMillis = 30000;
            return;
        }
        reloadDelayMillis = delayMillis;
    }

    public static long scaleTestSleepTime(long timeMillis) {
        System.out.println("sleeping: " + Math.round(testSleepTimeFactor * (double)timeMillis));
        return Math.round(testSleepTimeFactor * (double)timeMillis);
    }

    static {
        String fac;
        reloadDelayMillis = 1600;
        isReloadDelayMillisProperty = false;
        testSleepTimeFactor = 1.0;
        String delayProperty = System.getProperty(SPRING_RELOAD_DELAY_MILLIS);
        if (delayProperty != null) {
            try {
                reloadDelayMillis = Integer.parseInt(delayProperty);
                isReloadDelayMillisProperty = true;
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid format for -DSpringReloadDelayMillis. Using default value: " + reloadDelayMillis);
            }
        }
        if ((fac = System.getProperty(SPRING_TEST_SLEEP_TIME_FACTOR)) != null) {
            try {
                testSleepTimeFactor = Double.parseDouble(fac);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid format for -DSpringTestSleepTimeFactor.");
            }
        }
    }
}

