/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.scanner;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.IOUtils;
import org.hotswap.agent.watch.WatchFileEvent;

public class ClassPathBeanRefreshCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ClassPathBeanRefreshCommand.class);
    ClassLoader appClassLoader;
    String basePackage;
    String className;
    WatchFileEvent event;
    byte[] classDefinition;
    Scheduler scheduler;

    public ClassPathBeanRefreshCommand(ClassLoader appClassLoader, String basePackage, String className, byte[] classDefinition, Scheduler scheduler) {
        this.appClassLoader = appClassLoader;
        this.basePackage = basePackage;
        this.className = className;
        this.classDefinition = classDefinition;
        this.scheduler = scheduler;
    }

    public ClassPathBeanRefreshCommand(ClassLoader appClassLoader, String basePackage, String className, WatchFileEvent event, Scheduler scheduler) {
        this.appClassLoader = appClassLoader;
        this.basePackage = basePackage;
        this.event = event;
        this.className = className;
        this.scheduler = scheduler;
    }

    @Override
    public void executeCommand() {
        if (this.isDeleteEvent()) {
            LOGGER.trace("Skip Spring reload for delete event on class '{}'", this.className);
            return;
        }
        try {
            if (this.classDefinition == null) {
                try {
                    this.classDefinition = IOUtils.toByteArray(this.event.getURI());
                }
                catch (IllegalArgumentException e) {
                    LOGGER.debug("File {} not found on filesystem (deleted?). Unable to refresh associated Spring bean.", this.event.getURI());
                    return;
                }
            }
            LOGGER.debug("Executing ClassPathBeanDefinitionScannerAgent.refreshClass('{}')", this.className);
            Class<?> clazz = Class.forName("org.hotswap.agent.plugin.spring.scanner.ClassPathBeanDefinitionScannerAgent", true, this.appClassLoader);
            Method method = clazz.getDeclaredMethod("refreshClassAndCheckReload", ClassLoader.class, String.class, String.class, byte[].class);
            method.invoke(null, this.appClassLoader, this.basePackage, this.basePackage, this.classDefinition);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Plugin error, method not found", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Error refreshing class {} in classLoader {}", e, this.className, this.appClassLoader);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Plugin error, illegal access", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Plugin error, Spring class not found in application classloader", e);
        }
    }

    private boolean isDeleteEvent() {
        ArrayList<ClassPathBeanRefreshCommand> mergedCommands = new ArrayList<ClassPathBeanRefreshCommand>();
        for (Command command : this.getMergedCommands()) {
            mergedCommands.add((ClassPathBeanRefreshCommand)command);
        }
        mergedCommands.add(this);
        boolean createFound = false;
        boolean deleteFound = false;
        for (ClassPathBeanRefreshCommand command : mergedCommands) {
            if (command.event == null) continue;
            if (command.event.getEventType().equals((Object)FileEvent.DELETE)) {
                deleteFound = true;
            }
            if (!command.event.getEventType().equals((Object)FileEvent.CREATE)) continue;
            createFound = true;
        }
        LOGGER.trace("isDeleteEvent result {}: createFound={}, deleteFound={}", createFound, deleteFound);
        return !createFound && deleteFound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassPathBeanRefreshCommand that = (ClassPathBeanRefreshCommand)o;
        if (!this.appClassLoader.equals(that.appClassLoader)) {
            return false;
        }
        return this.className.equals(that.className);
    }

    public int hashCode() {
        int result = this.appClassLoader.hashCode();
        result = 31 * result + this.className.hashCode();
        return result;
    }

    public String toString() {
        return "ClassPathBeanRefreshCommand{appClassLoader=" + this.appClassLoader + ", basePackage='" + this.basePackage + '\'' + ", className='" + this.className + '\'' + '}';
    }
}

