/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.transformers;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtField;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;

public class PlaceholderConfigurerSupportTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PlaceholderConfigurerSupportTransformer.class);

    @OnClassLoadEvent(classNameRegexp="org.springframework.beans.factory.config.PlaceholderConfigurerSupport")
    public static void transform(CtClass clazz, ClassPool classPool) throws NotFoundException, CannotCompileException {
        for (CtClass interfaceClazz : clazz.getInterfaces()) {
            if (!interfaceClazz.getName().equals("org.hotswap.agent.plugin.spring.transformers.api.ValueResolverSupport")) continue;
            return;
        }
        clazz.addInterface(classPool.get("org.hotswap.agent.plugin.spring.transformers.api.ValueResolverSupport"));
        clazz.addField(CtField.make("private java.util.List _resolvers;", clazz), "new java.util.ArrayList(2)");
        clazz.addMethod(CtMethod.make("public java.util.List valueResolvers() { return this._resolvers; }", clazz));
        CtMethod ctMethod = clazz.getDeclaredMethod("doProcessProperties", new CtClass[]{classPool.get("org.springframework.beans.factory.config.ConfigurableListableBeanFactory"), classPool.get("org.springframework.util.StringValueResolver")});
        ctMethod.insertBefore("org.hotswap.agent.plugin.spring.reload.SpringChangedAgent.collectPlaceholderProperties($1); this._resolvers.add($2);");
        LOGGER.debug("class 'org.springframework.beans.factory.config.PlaceholderConfigurerSupport' patched with placeholder keep.", new Object[0]);
    }
}

