/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.webobjects;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.PluginManagerInvoker;

@Plugin(name="WebObjects", description="Hotswap agent plugin for WebObjects app.", testedVersions={"5.4.3"}, expectedVersions={"5.4.3"})
public class HotswapWebObjectsPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(HotswapWebObjectsPlugin.class);
    @Init
    Scheduler scheduler;
    private Method kvcDefaultImplementation_flushCaches;
    private Method kvcReflectionKeyBindingCreation_flushCaches;
    private Method kvcValueAccessor_flushCaches;
    private Method nsValidationDefaultImplementation_flushCaches;
    private Method woApplication_removeComponentDefinitionCacheContents;
    private Object woApplicationObject;
    private Method nsThreadsafeMutableDictionary_removeAllObjects;
    private Object actionClassesCacheDictionnary;
    private CtClass woActionCtClass;
    private CtClass woComponentCtClass;
    private CtClass nsValidationCtClass;
    private ClearKVCCache clearKVCCacheCommand = new ClearKVCCache();
    private ClearComponentCache clearComponentCacheCommand = new ClearComponentCache();
    private ClearActionCache clearActionCacheCommand = new ClearActionCache();
    private ClearValidationCache clearValidationCacheCommand = new ClearValidationCache();

    @OnClassLoadEvent(classNameRegexp="com.webobjects.appserver.WOApplication")
    public static void webObjectsIsStarting(CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtMethod init = ctClass.getDeclaredMethod("run");
        init.insertBefore(PluginManagerInvoker.buildInitializePlugin(HotswapWebObjectsPlugin.class));
        LOGGER.debug("WOApplication.run() enhanced with plugin initialization.", new Object[0]);
    }

    @Init
    public void init(PluginConfiguration pluginConfiguration, ClassLoader appClassLoader) {
        try {
            Class<?> kvcDefaultImplementationClass = Class.forName("com.webobjects.foundation.NSKeyValueCoding$DefaultImplementation", false, appClassLoader);
            this.kvcDefaultImplementation_flushCaches = kvcDefaultImplementationClass.getMethod("_flushCaches", new Class[0]);
            Class<?> kvcReflectionKeyBindingCreationClass = Class.forName("com.webobjects.foundation.NSKeyValueCoding$_ReflectionKeyBindingCreation", false, appClassLoader);
            this.kvcReflectionKeyBindingCreation_flushCaches = kvcReflectionKeyBindingCreationClass.getMethod("_flushCaches", new Class[0]);
            Class<?> kvcValueAccessorClass = Class.forName("com.webobjects.foundation.NSKeyValueCoding$ValueAccessor", false, appClassLoader);
            this.kvcValueAccessor_flushCaches = kvcValueAccessorClass.getMethod("_flushCaches", new Class[0]);
            Class<?> nsValidationDefaultImplementationClass = Class.forName("com.webobjects.foundation.NSValidation$DefaultImplementation", false, appClassLoader);
            this.nsValidationDefaultImplementation_flushCaches = nsValidationDefaultImplementationClass.getMethod("_flushCaches", new Class[0]);
            Class<?> woApplicationClass = Class.forName("com.webobjects.appserver.WOApplication", false, appClassLoader);
            this.woApplication_removeComponentDefinitionCacheContents = woApplicationClass.getMethod("_removeComponentDefinitionCacheContents", new Class[0]);
            this.woApplicationObject = woApplicationClass.getMethod("application", new Class[0]).invoke(null, new Object[0]);
            ClassPool classPool = ClassPool.getDefault();
            this.woComponentCtClass = classPool.makeClass("com.webobjects.appserver.WOComponent");
            this.nsValidationCtClass = classPool.makeClass("com.webobjects.foundation.NSValidation");
            this.woActionCtClass = classPool.makeClass("com.webobjects.appserver.WOAction");
            Class<?> woActionClass = Class.forName("com.webobjects.appserver.WOAction", false, appClassLoader);
            Field actionClassesField = woActionClass.getDeclaredField("_actionClasses");
            actionClassesField.setAccessible(true);
            this.actionClassesCacheDictionnary = actionClassesField.get(null);
            Class<?> nsThreadsafeMutableDictionaryClass = Class.forName("com.webobjects.foundation._NSThreadsafeMutableDictionary", false, appClassLoader);
            this.woApplication_removeComponentDefinitionCacheContents = woApplicationClass.getMethod("_removeComponentDefinitionCacheContents", new Class[0]);
            this.nsThreadsafeMutableDictionary_removeAllObjects = nsThreadsafeMutableDictionaryClass.getMethod("removeAllObjects", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void reloadClass(CtClass ctClass) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, CannotCompileException {
        LOGGER.debug("Class " + ctClass.getSimpleName() + " redefined.", new Object[0]);
        this.scheduler.scheduleCommand(this.clearKVCCacheCommand);
        this.scheduler.scheduleCommand(this.clearValidationCacheCommand);
        this.woApplication_removeComponentDefinitionCacheContents.invoke(this.woApplicationObject, new Object[0]);
        if (ctClass.subclassOf(this.woComponentCtClass)) {
            this.scheduler.scheduleCommand(this.clearComponentCacheCommand);
        }
        if (ctClass.subclassOf(this.woActionCtClass)) {
            this.scheduler.scheduleCommand(this.clearActionCacheCommand);
        }
    }

    public class ClearValidationCache
    implements Command {
        @Override
        public void executeCommand() {
            try {
                HotswapWebObjectsPlugin.this.nsValidationDefaultImplementation_flushCaches.invoke(null, new Object[0]);
                LOGGER.info("Resetting NSValidation cache", new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class ClearActionCache
    implements Command {
        @Override
        public void executeCommand() {
            try {
                HotswapWebObjectsPlugin.this.nsThreadsafeMutableDictionary_removeAllObjects.invoke(HotswapWebObjectsPlugin.this.actionClassesCacheDictionnary, new Object[0]);
                LOGGER.info("Resetting Action class cache", new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class ClearComponentCache
    implements Command {
        @Override
        public void executeCommand() {
            try {
                HotswapWebObjectsPlugin.this.woApplication_removeComponentDefinitionCacheContents.invoke(HotswapWebObjectsPlugin.this.woApplicationObject, new Object[0]);
                LOGGER.info("Resetting Component Definition cache", new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class ClearKVCCache
    implements Command {
        @Override
        public void executeCommand() {
            try {
                HotswapWebObjectsPlugin.this.kvcDefaultImplementation_flushCaches.invoke(null, new Object[0]);
                HotswapWebObjectsPlugin.this.kvcReflectionKeyBindingCreation_flushCaches.invoke(null, new Object[0]);
                HotswapWebObjectsPlugin.this.kvcValueAccessor_flushCaches.invoke(null, new Object[0]);
                LOGGER.info("Resetting KeyValueCoding caches", new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

