/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.weld_jakarta;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.weld_jakarta.BeanReloadStrategy;
import org.hotswap.agent.plugin.weld_jakarta.WeldClassSignatureHelper;
import org.hotswap.agent.plugin.weld_jakarta.command.BdaAgentRegistry;
import org.hotswap.agent.plugin.weld_jakarta.command.BeanClassRefreshCommand;
import org.hotswap.agent.plugin.weld_jakarta.transformer.AbstractClassBeanTransformer;
import org.hotswap.agent.plugin.weld_jakarta.transformer.BeanDeploymentArchiveTransformer;
import org.hotswap.agent.plugin.weld_jakarta.transformer.CdiContextsTransformer;
import org.hotswap.agent.plugin.weld_jakarta.transformer.ProxyFactoryTransformer;
import org.hotswap.agent.util.AnnotationHelper;
import org.hotswap.agent.util.IOUtils;
import org.hotswap.agent.util.ReflectionHelper;
import org.hotswap.agent.util.classloader.ClassLoaderHelper;
import org.hotswap.agent.util.signature.ClassSignatureComparerHelper;
import org.hotswap.agent.util.signature.ClassSignatureElement;
import org.hotswap.agent.watch.WatchEventListener;
import org.hotswap.agent.watch.WatchFileEvent;
import org.hotswap.agent.watch.Watcher;

@Plugin(name="WeldJakarta", description="Weld Jakarta framework(http://weld.cdi-spec.org/). Reload, reinject bean, redefine proxy class after bean class definition/redefinition.", testedVersions={"5.1.2"}, expectedVersions={"5.x"}, supportClass={BeanDeploymentArchiveTransformer.class, ProxyFactoryTransformer.class, AbstractClassBeanTransformer.class, CdiContextsTransformer.class})
public class WeldJakartaPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(WeldJakartaPlugin.class);
    private static final String VETOED_ANNOTATION = "jakarta.enterprise.inject.Vetoed";
    private static final String DS_EXCLUDED_ANNOTATION = "org.apache.deltaspike.core.api.exclude.Exclude";
    static boolean isTestEnvironment = false;
    private static final int WAIT_ON_CREATE = 500;
    private static final int WAIT_ON_REDEFINE = 200;
    @Init
    Watcher watcher;
    @Init
    Scheduler scheduler;
    @Init
    ClassLoader appClassLoader;
    @Init
    PluginConfiguration pluginConfiguration;
    boolean initialized = false;
    private Map<Object, Object> registeredProxiedBeans = new WeakHashMap<Object, Object>();
    private BeanReloadStrategy beanReloadStrategy;

    public void init() {
        if (!this.initialized) {
            LOGGER.info("Weld plugin initialized.", new Object[0]);
            this.doInit();
        }
    }

    public void initInJBossAS() {
        if (!this.initialized) {
            LOGGER.info("WeldJakarta plugin initialized in JBossAS.", new Object[0]);
            this.doInit();
        }
    }

    public void initInGlassFish() {
        if (!this.initialized) {
            LOGGER.info("WeldJakarta plugin initialized in GlassFish.", new Object[0]);
            this.doInit();
        }
    }

    private void doInit() {
        this.initialized = true;
        this.beanReloadStrategy = this.setBeanReloadStrategy(this.pluginConfiguration.getProperty("weld.beanReloadStrategy"));
    }

    private BeanReloadStrategy setBeanReloadStrategy(String property) {
        BeanReloadStrategy ret = BeanReloadStrategy.NEVER;
        if (property != null && !property.isEmpty()) {
            try {
                ret = BeanReloadStrategy.valueOf(property);
            }
            catch (Exception e) {
                LOGGER.error("Unknown property 'weld.beanReloadStrategy' value: {} ", property);
            }
        }
        return ret;
    }

    public synchronized void registerBeanDeplArchivePath(final String archivePath) {
        URL resource = null;
        try {
            resource = this.resourceNameToURL(archivePath);
            URI uri = resource.toURI();
            if (!IOUtils.isDirectoryURL(uri.toURL())) {
                LOGGER.trace("Unable to watch for new files. Archive '{}' is not directory.", archivePath);
                return;
            }
            LOGGER.info("Registering archive path '{}'", archivePath);
            this.watcher.addEventListener(this.appClassLoader, uri, new WatchEventListener(){

                @Override
                public void onEvent(WatchFileEvent event) {
                    if (event.isFile() && event.getURI().toString().endsWith(".class")) {
                        String className;
                        try {
                            className = IOUtils.urlToClassName(event.getURI());
                        }
                        catch (IOException e) {
                            LOGGER.trace("Watch event on resource '{}' skipped, probably Ok because of delete/create event sequence (compilation not finished yet).", e, event.getURI());
                            return;
                        }
                        if (!ClassLoaderHelper.isClassLoaded(WeldJakartaPlugin.this.appClassLoader, className) || isTestEnvironment) {
                            LOGGER.trace("Register reload command: {} ", className);
                            if (WeldJakartaPlugin.isBdaRegistered(WeldJakartaPlugin.this.appClassLoader, archivePath)) {
                                WeldJakartaPlugin.this.scheduler.scheduleCommand(new BeanClassRefreshCommand(WeldJakartaPlugin.this.appClassLoader, archivePath, event), 500);
                            }
                        }
                    }
                }
            });
            LOGGER.info("Registered  watch for path '{}' for changes.", resource);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Unable to watch path '{}' for changes.", e, archivePath);
        }
        catch (Exception e) {
            LOGGER.warning("registerBeanDeplArchivePath() exception : {}", e.getMessage());
        }
    }

    private static boolean isBdaRegistered(ClassLoader classLoader, String archivePath) {
        if (archivePath != null) {
            try {
                return (Boolean)ReflectionHelper.invoke(null, Class.forName(BdaAgentRegistry.class.getName(), true, classLoader), "contains", new Class[]{String.class}, archivePath);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("isBdaRegistered() exception {}.", e.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProxyFactory(Object proxyFactory, Object bean, ClassLoader classLoader, Class<?> proxiedBeanType) {
        Map<Object, Object> map = this.registeredProxiedBeans;
        synchronized (map) {
            if (!this.registeredProxiedBeans.containsKey(bean)) {
                LOGGER.debug("ProxyFactory for '{}' registered.", bean);
            }
            this.registeredProxiedBeans.put(bean, proxyFactory);
        }
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void classReload(ClassLoader classLoader, CtClass ctClass, Class<?> original) {
        if (AnnotationHelper.hasAnnotation(ctClass, VETOED_ANNOTATION)) {
            LOGGER.trace("Skipping @Vetoed class {}.", ctClass.getName());
            return;
        }
        if (original == null || this.isSyntheticCdiClass(ctClass.getName()) || this.isInnerNonPublicStaticClass(ctClass)) {
            if (original != null) {
                LOGGER.trace("Skipping synthetic or inner class {}.", original.getName());
            }
            return;
        }
        if (AnnotationHelper.hasAnnotation(ctClass, VETOED_ANNOTATION)) {
            LOGGER.trace("Skipping @Vetoed class {}.", ctClass.getName());
            return;
        }
        if (AnnotationHelper.hasAnnotation(ctClass, DS_EXCLUDED_ANNOTATION)) {
            LOGGER.trace("Skipping @Excluded class {}.", ctClass.getName());
            return;
        }
        try {
            String archivePath = this.getArchivePath(classLoader, ctClass, original.getName());
            if (WeldJakartaPlugin.isBdaRegistered(classLoader, archivePath)) {
                LOGGER.debug("Class '{}' redefined for archive {} ", original.getName(), archivePath);
                String oldSignatureForProxyCheck = WeldClassSignatureHelper.getSignatureForProxyClass(original);
                String oldSignatureByStrategy = WeldClassSignatureHelper.getSignatureByStrategy(this.beanReloadStrategy, original);
                String oldFullSignature = ClassSignatureComparerHelper.getJavaClassSignature(original, ClassSignatureElement.values());
                this.scheduler.scheduleCommand(new BeanClassRefreshCommand(classLoader, archivePath, this.registeredProxiedBeans, original.getName(), oldFullSignature, oldSignatureForProxyCheck, oldSignatureByStrategy, this.beanReloadStrategy), 200);
            }
        }
        catch (Exception e) {
            LOGGER.error("classReload() exception {}.", e, e.getMessage());
        }
    }

    private String getArchivePath(ClassLoader classLoader, CtClass ctClass, String knownClassName) throws NotFoundException {
        try {
            return (String)ReflectionHelper.invoke(null, Class.forName(BdaAgentRegistry.class.getName(), true, classLoader), "getArchiveByClassName", new Class[]{String.class}, knownClassName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("getArchivePath() exception {}.", e.getMessage());
            String classFilePath = ctClass.getURL().getPath();
            String className = ctClass.getName().replace(".", "/");
            String archivePath = classFilePath.substring(0, classFilePath.indexOf(className) - 1);
            return new File(archivePath).toPath().toString();
        }
    }

    public URL resourceNameToURL(String resource) throws Exception {
        try {
            return new URL(resource);
        }
        catch (MalformedURLException e) {
            if (resource.startsWith("./")) {
                resource = resource.substring(2);
            }
            File file = new File(resource).getCanonicalFile();
            return file.toURI().toURL();
        }
    }

    private boolean isSyntheticCdiClass(String className) {
        return className.contains("$Proxy$") || className.contains("$$");
    }

    private boolean isInnerNonPublicStaticClass(CtClass ctClass) {
        try {
            if (ctClass.isInnerClass() && ((ctClass.getModifiers() & 8) == 0 || (ctClass.getModifiers() & 1) == 0)) {
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }
}

