/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.watch.nio;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import org.hotswap.agent.watch.nio.AbstractNIO2Watcher;

public class TreeWatcherNIO
extends AbstractNIO2Watcher {
    private static final WatchEvent.Modifier HIGH = TreeWatcherNIO.getWatchEventModifier("com.sun.nio.file.SensitivityWatchEventModifier", "HIGH");
    private static final WatchEvent.Modifier FILE_TREE = TreeWatcherNIO.getWatchEventModifier("com.sun.nio.file.ExtendedWatchEventModifier", "FILE_TREE");
    private static final WatchEvent.Modifier[] MODIFIERS = FILE_TREE != null ? new WatchEvent.Modifier[]{FILE_TREE, HIGH} : new WatchEvent.Modifier[]{HIGH};

    private void register(Path dir) throws IOException {
        for (Path p : this.keys.values()) {
            if (!dir.startsWith(p)) continue;
            this.LOGGER.debug("Path {} watched via {}", dir, p);
            return;
        }
        if (FILE_TREE == null) {
            this.LOGGER.debug("WATCHING:ENTRY_CREATE, ENTRY_DELETE, ENTRY_MODIFY - high} {}", dir);
        } else {
            this.LOGGER.debug("WATCHING: ENTRY_CREATE, ENTRY_DELETE, ENTRY_MODIFY - fileTree,high {}", dir);
        }
        WatchKey key = dir.register(this.watcher, KINDS, MODIFIERS);
        this.keys.put(key, dir);
    }

    @Override
    protected void registerAll(Path dir, boolean fromCreateEvent) throws IOException {
        this.LOGGER.info("Registering directory {} ", dir);
        this.register(dir);
    }
}

