/*
 * Decompiled with CFR 0.152.
 */
package org.hoyi.microservice;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import net.sf.json.JSONObject;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.hoyi.DB.conf.HOYIConf;
import org.hoyi.DB.ctrl.Console;
import org.hoyi.DB.util.ConfigUtil;
import org.hoyi.ctrls.sys.sh.ShellCtrls;
import org.hoyi.dishop.Hoyipage;
import org.hoyi.dispatchs.DispatcherServlet;
import org.hoyi.microservice.HoyiServiceConfig;
import org.hoyi.servmotions.refreshpage_motion;
import org.hoyi.sessionlisten.SessionIniter;
import org.hoyi.util.HTMLUtils;
import org.hoyi.util.HttpRequest;
import org.hoyi.util.StreamUtils;
import org.hoyi.websocket.HoyiWebSocketHandler;
import org.hoyi.websocket.WebSocketConf;
import org.yaml.snakeyaml.Yaml;

public class HoyiCloudApplication {
    public static boolean CloudAppStarting = false;
    public static boolean DebugMode = false;
    public static boolean AutoRefreshPage = false;
    public static int AutoRefreshSeconds = 3;
    public static boolean Motion_Page_Newest = false;
    public static int Motion_Page_Newest_millons = 300;
    public static boolean Motion_Page_Newest_Console_Log = false;
    public static boolean OpenLocalWebRoot = false;
    public static String WebRootPath = "";
    public static int REQ_PORT = -1;
    public static String NEED_PORT;
    public static HoyiServiceConfig hoyiconfig;
    public static long cloud_staringtime;
    private static Map<String, List<String>> PORT_BAKS;
    private static Map<String, List<String>> PORT_USED;
    public static boolean ConfigLoaded;
    private static Server server;

    public static void LoadConfig() {
        if (!ConfigLoaded) {
            try {
                Yaml yaml = new Yaml();
                File files = null;
                if (ConfigUtil.OpenOuterConfig) {
                    if (ConfigUtil.OuterConfigPath.trim().length() > 0) {
                        files = new File(ConfigUtil.OuterConfigPath);
                    } else {
                        files = new File("");
                        files = new File(files.getAbsoluteFile() + "/config");
                    }
                } else if (ConfigUtil.Open_HostRoot_Config) {
                    files = new File("");
                    files = new File(files.getAbsoluteFile() + "/config");
                }
                if (files != null) {
                    String path = files.getAbsolutePath() + "/hoyi-service.yml";
                    Console.Info((String)("begin Load config Path:" + path));
                    byte[] configbts = StreamUtils.Create().ReadLocalFileResource(path);
                    String configcontent = new String(configbts, "UTF-8");
                    Console.Info((String)("Config:" + configcontent));
                    hoyiconfig = (HoyiServiceConfig)yaml.loadAs(configcontent, HoyiServiceConfig.class);
                } else {
                    hoyiconfig = (HoyiServiceConfig)yaml.loadAs(HoyiCloudApplication.class.getResourceAsStream("/config/hoyi-service.yml"), HoyiServiceConfig.class);
                }
                if (hoyiconfig == null) {
                    hoyiconfig = new HoyiServiceConfig();
                }
                Console.Info((String)hoyiconfig.toString());
            }
            catch (Exception e) {
                hoyiconfig = new HoyiServiceConfig();
                Console.Info((String)"No Hoyi Cloud Configureation File!");
            }
            ConfigLoaded = true;
        }
    }

    public static void BeginMotionPageModi() {
        String OpenDebugPath;
        if (Motion_Page_Newest && !(OpenDebugPath = hoyiconfig.getHOYI().getOrDefault("OpenDebugPath", "NoNeed")).equals("NoNeed")) {
            String[] _paths = new String[]{OpenDebugPath};
            refreshpage_motion.Begin_Motion(_paths);
        }
    }

    public static void Start() {
        HoyiCloudApplication.Start(REQ_PORT, ".", (Servlet)new DispatcherServlet());
    }

    public static void Start(int port) {
        HoyiCloudApplication.Start(port, ".", (Servlet)new DispatcherServlet());
    }

    public static void StopPort(int port) {
        ShellCtrls _shell = new ShellCtrls();
        String result = _shell.StopPort(port);
        Console.Info((String)("port:" + port + " stoped , ret:" + result));
    }

    public static void StopPortIfRunning(int port) {
        ShellCtrls _shell = new ShellCtrls();
        Console.Info((String)("OS NAME:" + _shell.GetOsName()));
        boolean isrunning = _shell.PortisRuning(port);
        if (isrunning) {
            HoyiCloudApplication.StopPort(port);
        }
    }

    public static void Start(int port, String webcontent) {
        HoyiCloudApplication.Start(port, webcontent, (Servlet)new DispatcherServlet());
    }

    public static void OpenLocalWebRoot(String _local_webRootPath) {
        OpenLocalWebRoot = true;
        WebRootPath = _local_webRootPath;
    }

    public static void OpenOutConfig(String outerconfigpath) {
        ConfigUtil.OpenOuterConfig = true;
        ConfigUtil.OuterConfigPath = outerconfigpath;
    }

    public static void OpenLocalCustomFile(String _local_custom_file_path) {
        HOYIConf.OpenLocalCustomFile((String)_local_custom_file_path);
    }

    public static void OpenRootConfig() {
        ConfigUtil.Open_HostRoot_Config = true;
    }

    public static void OpenDebug() {
        DebugMode = true;
        Hoyipage.OpenCacheHTML = false;
        HTMLUtils.OpenHTMLCache = false;
        HOYIConf.PageCache = false;
    }

    public static void OpenDebug(String _local_webRoot_path) {
        HoyiCloudApplication.OpenDebug();
        HoyiCloudApplication.OpenLocalWebRoot(_local_webRoot_path);
    }

    public static void OpenAutoRefresh(int refreshsec) {
        AutoRefreshSeconds = refreshsec;
        AutoRefreshPage = true;
    }

    public static Server getServer() {
        return server;
    }

    public static void Start(int port, Servlet startservlet) {
        HoyiCloudApplication.Start(port, ".", startservlet);
    }

    public static void Start(int port, String webcontent, Servlet startservlet) {
        HoyiCloudApplication.Start(port, webcontent, startservlet, false, true);
    }

    public static void Start(int port, String webcontent, Servlet startservlet, boolean OpenWebSocket) {
        HoyiCloudApplication.Start(port, webcontent, startservlet, OpenWebSocket, true);
    }

    public static void Start(int port, String webcontent, Servlet startservlet, boolean OpenWebSocket, boolean OpenWebServer) {
        cloud_staringtime = System.currentTimeMillis();
        CloudAppStarting = true;
        HoyiCloudApplication.LoadConfig();
        NEED_PORT = hoyiconfig.getHOYI().getOrDefault("NEED-PORT", "false");
        String SERVICETYPE = hoyiconfig.getSERVICE().getOrDefault("SERVICE-TYPE", "PROVIDER");
        String DISPATCHURL = hoyiconfig.getSERVICE().get("DISPATCHER-URL");
        String SERVICEID = hoyiconfig.getSERVICE().get("SERVICE-ID");
        String HOST = hoyiconfig.getHOYI().get("HOST");
        System.out.println("DISPATCHER-URL:" + DISPATCHURL);
        if (NEED_PORT.trim().toUpperCase().equals("TRUE")) {
            System.out.println("Get Start ServicePort:" + DISPATCHURL + "index/GetStartPort.html");
            String PORT_BAK = hoyiconfig.getHOYI().get("PORT-BAK");
            HttpRequest request = new HttpRequest();
            try {
                String ret = HttpRequest.sendPost(DISPATCHURL + "index/GetStartPort.html", "serviceid=" + SERVICEID + "&host=" + HOST + "&portbaks=" + PORT_BAK);
                Console.Info((String)("ERT:" + ret));
                JSONObject obj = JSONObject.fromObject((Object)ret);
                String sgetport = obj.get("data").toString();
                Console.Info((String)("Register Service:" + ret));
                if (sgetport == null || sgetport.toString().length() <= 0) {
                    Console.Info((String)"\u672a\u80fd\u5206\u914d\u542f\u52a8\u7aef\u53e3\uff0c\u5173\u95ed\u670d\u52a1");
                    return;
                }
                REQ_PORT = Integer.parseInt(sgetport.toString());
            }
            catch (UnsupportedEncodingException e) {
                Console.Error((String)("Getstartport error:" + e.getMessage()));
            }
        } else {
            REQ_PORT = port == -1 ? Integer.parseInt(hoyiconfig.getHOYI().getOrDefault("PORT", "8080")) : port;
            Console.Info((String)("port:" + REQ_PORT));
        }
        HoyiCloudApplication.BeginMotionPageModi();
        if ("PROVIDER".equals(SERVICETYPE) && DISPATCHURL != null && DISPATCHURL.trim().length() > 1) {
            System.out.println("Register Service URL:" + DISPATCHURL + "index/RegisterService.html");
            HttpRequest request = new HttpRequest();
            try {
                String ret = HttpRequest.sendPost(DISPATCHURL + "index/RegisterService.html", "serviceid=" + SERVICEID + "&host=" + HOST + "&port=" + REQ_PORT);
                Console.Info((String)("Register Service:" + ret));
            }
            catch (UnsupportedEncodingException e) {
                Console.Info((String)("Register Service:" + e.getMessage()));
            }
        }
        try {
            InetSocketAddress address;
            Console.Info((String)"Begin Server:");
            if (webcontent.equals("./WebContent")) {
                address = new InetSocketAddress(REQ_PORT);
                server = new Server(address);
                WebAppContext webAppContext = new WebAppContext();
                webAppContext.setContextPath("/");
                Console.Info((String)"Set Web Content: WebContent:");
                File resDir = new File(webcontent);
                webAppContext.setResourceBase(resDir.getCanonicalPath());
                webAppContext.setConfigurationDiscovered(true);
                webAppContext.setParentLoaderPriority(true);
                server.setHandler((Handler)webAppContext);
                Console.Info((String)"Begin Server Finished:");
                server.start();
                server.join();
            } else {
                Console.Info((String)"Start Jerry Server.");
                address = new InetSocketAddress(REQ_PORT);
                server = new Server(address);
                ContextHandlerCollection context = new ContextHandlerCollection();
                if (OpenWebSocket) {
                    for (String _req_path : WebSocketConf.WebSocketPathHandler.keySet()) {
                        HoyiWebSocketHandler _websocketHandler = WebSocketConf.WebSocketPathHandler.get(_req_path);
                        ContextHandler contextHandler = new ContextHandler();
                        contextHandler.setContextPath(_websocketHandler.Req_Path);
                        contextHandler.setHandler((Handler)_websocketHandler);
                        context.addHandler((Handler)contextHandler);
                    }
                    Console.Info((String)"Websocket Server Started!~");
                }
                if (OpenWebServer) {
                    WebAppContext webAppContext = new WebAppContext();
                    webAppContext.setContextPath("/");
                    webAppContext.setResourceBase(".");
                    webAppContext.addServlet(new ServletHolder(startservlet), "/*");
                    webAppContext.setConfigurationDiscovered(true);
                    webAppContext.setParentLoaderPriority(true);
                    context.addHandler((Handler)webAppContext);
                }
                server.setHandler((Handler)context);
                Console.Info((String)"Start Server Finished.");
                SessionIniter.getInstance().contextInitialized();
            }
            server.start();
            server.join();
        }
        catch (Exception e) {
            HoyiCloudApplication.Stop();
        }
    }

    public static void Stop() {
        Console.Error((String)"Application Closed:");
        try {
            SessionIniter.getInstance().contextDestroyed();
        }
        catch (Exception e) {
            Console.Error((Exception)e);
        }
        try {
            if (server != null) {
                server.stop();
            }
        }
        catch (Exception e1) {
            Console.Error((Exception)e1);
        }
    }

    public static void Restart() {
        try {
            Console.Info((String)"Server Restarted");
            WebAppContext context = (WebAppContext)server.getHandler();
            context.stop();
            WebAppClassLoader classLoader = new WebAppClassLoader((WebAppClassLoader.Context)context);
            context.setClassLoader((ClassLoader)classLoader);
            context.start();
        }
        catch (Exception e) {
            Console.Error((String)("Restart Error:" + e.getMessage()));
        }
    }

    public static Map<String, List<String>> getPORT_BAKS() {
        return PORT_BAKS;
    }

    public static void setPORT_BAKS(Map<String, List<String>> pORT_BAKS) {
        PORT_BAKS = pORT_BAKS;
    }

    public static Map<String, List<String>> getPORT_USED() {
        return PORT_USED;
    }

    public static void setPORT_USED(Map<String, List<String>> pORT_USED) {
        PORT_USED = pORT_USED;
    }

    public static void AddBAKPorts(String host, String port) {
        List<String> ps = PORT_BAKS.get(host);
        if (ps != null) {
            ps.add(port);
            PORT_BAKS.remove(host);
            PORT_BAKS.put(host, ps);
        } else {
            ps = new ArrayList<String>();
            ps.add(port);
            PORT_BAKS.put(host, ps);
        }
    }

    public static void RemoveBakPorts(String host, String port) {
        List<String> ps = PORT_BAKS.get(host);
        if (ps != null && ps.contains(port)) {
            ps.remove(port);
        }
        PORT_BAKS.remove(host);
        PORT_BAKS.put(host, ps);
    }

    public static void UsedPort(String host, String port) {
        List<String> ps = PORT_USED.get(host);
        if (ps != null) {
            ps.add(port);
            PORT_USED.remove(host);
            PORT_USED.put(host, ps);
        } else {
            ps = new ArrayList<String>();
            ps.add(port);
            PORT_USED.put(host, ps);
        }
        HoyiCloudApplication.RemoveBakPorts(host, port);
    }

    static {
        cloud_staringtime = -1L;
        PORT_BAKS = new HashMap<String, List<String>>();
        PORT_USED = new HashMap<String, List<String>>();
        ConfigLoaded = false;
        server = null;
    }
}

