/**
 * 原生发送HTTP请求
 */
function httpRequest(paramObj,fun,errFun) {
	var xmlhttp = null;
	/*创建XMLHttpRequest对象，
	 *老版本的 Internet Explorer（IE5 和 IE6）使用 ActiveX 对象：new ActiveXObject("Microsoft.XMLHTTP")
	 * */
	if(window.XMLHttpRequest) {
		xmlhttp = new XMLHttpRequest();
	}else if(window.ActiveXObject) {
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	/*判断是否支持请求*/
	if(xmlhttp == null) {
		console.log('你的浏览器不支持XMLHttp');
		return;
	}
	/*请求方式，并且转换为大写*/
	var httpType = (paramObj.type || 'GET').toUpperCase();
	/*数据类型*/
	var dataType = paramObj.dataType || 'json';
	/*请求接口*/
	var httpUrl = paramObj.httpUrl || '';
	/*是否异步请求*/
	var async = paramObj.async || true;
	/*请求参数--post请求参数格式为：foo=bar&lorem=ipsum*/
	var paramData = paramObj.data || [];
	var requestData = '';
	for(var name in paramData) {
		requestData += name + '='+ paramData[name] + '&';
	}
	requestData = requestData == '' ? '' : requestData.substring(0,requestData.length - 1);
//	console.log(requestData)
	
	/*请求接收*/
	xmlhttp.onreadystatechange = function() {
    if(xmlhttp.readyState == 4 && xmlhttp.status == 200) {
      /*成功回调函数*/
      fun(xmlhttp.responseText);
    }else{
    	/*失败回调函数*/
    	errFun;
    }
	}			
	
	/*接口连接，先判断连接类型是post还是get*/
	if(httpType == 'GET') {
		xmlhttp.open("GET",httpUrl,async);
		xmlhttp.send(null);
	}else if(httpType == 'POST'){
		xmlhttp.open("POST",httpUrl,async);
		//发送合适的请求头信息
		xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded"); 
		xmlhttp.send(requestData); 
	}
}

function getCookie(name) {
    var prefix = name + "="
    var start = document.cookie.indexOf(prefix)
 
    if (start == -1) {
        return null;
    }
 
    var end = document.cookie.indexOf(";", start + prefix.length)
    if (end == -1) {
        end = document.cookie.length;
    }
 
    var value = document.cookie.substring(start + prefix.length, end)
    return unescape(value);
}

//写cookies
function setCookie(name,value)
{
	var Days = 30;
	var exp = new Date();
	exp.setTime(exp.getTime() + Days*24*60*60*1000);
	document.cookie = name + "="+ escape (value) + ";expires=" + exp.toGMTString();
}
// 是否输出监听的日期信息，不输出，则改为false.一堆输出也挺头大，但是不输出，你会觉得他没有刷新.
// 要调试请求，就把motion关掉就可以了.
var isconsole_hoyi_page_motion = true;
// 在调试的时候监听文件目录是否有修改，如果有修改则刷新当前页面，主要是为了方便前端界面编写的时候，需要手动刷新页面的问题.
function Hoyi_Page_Refresh_Motion(){
    var paramObj = {
         httpUrl : '/hoyicloud/motions/WorkSpaceMotions/CanRefreshPage.html',
         type : 'post',
         data : { }
    }
    /*请求调用*/
    httpRequest(paramObj, function(respondDada) {
       var lastmoditime = JSON.parse(respondDada).data.lastmoditime
       // 这里如果最后更新的时间比本地的大，则刷新.
       var local_lastmoditime = getCookie('hoyi-page-refresh-motion');
       if(local_lastmoditime == ""){
         setCookie('hoyi-page-refresh-motion', lastmoditime)
         window.location.reload()
         // console.log('local_lastmoditime is null')
       }else{
         // console.log('local_lastmoditime:' + local_lastmoditime)
         // 如果有的话，那就比较两个时间的大小，如果更新到的比本地的大，那么就刷新.
         lastmoditime = lastmoditime.replace("-","/")
         local_lastmoditime = local_lastmoditime.replace("-","/")
         var hoyi_ser_lastDate = new Date(lastmoditime)
         var hoyi_local_lastDate = new Date(local_lastmoditime)
         if(hoyi_ser_lastDate > hoyi_local_lastDate){
        	setCookie('hoyi-page-refresh-motion', lastmoditime)
            window.location.reload()
         }
       }
       //这里编写成功的回调函数
       if(isconsole_hoyi_page_motion){
           console.log('lastmoditime:' + lastmoditime)
       }
       // console.log('pg modied.motion:' + JSON.stringify(respondDada))
    },function() {
       console.log('page modied motion.网络错误')
    });
}
// 调用用这个，这里为了能设置刷新的时间，所以放到页面去调用.
//setInterval(Hoyi_Page_Refresh_Motion, 300)

