package org.hoyi.dispatchs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.hoyi.DB.ctrl.Console;
import org.hoyi.configs.HoyiWebConfig;
import org.hoyi.configs.ctrls.CrossCtrls;
import org.hoyi.dispatchfact.CustomFileDispatcher;
import org.hoyi.dispatchfact.HoyiPageDispatcher;
import org.hoyi.dispatchfact.IDispatcher;
import org.hoyi.dispatchfact.MappingDispatcher;
import org.hoyi.dispatchfact.PureForeDispatcher;
import org.hoyi.dispatchfact.WELCOMEDispatcher;
import org.hoyi.wb.comment.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Author:ellen Email:ellen@kuaifish.com CreateDate:2015-05-20
 * ModifyDate:2015-06-20 hoyi entities @ hoyi.org 使用请在项目关于内标注hoyi版权，
 * hoyi版权归hoyi.org所有
 */
@WebServlet({ "/DispatcherServlet" })
public class DispatcherServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;
	public boolean ConsoleURL = false;

	public boolean ConsoleURLFULL = true;
	private static Logger Log = LoggerFactory.getLogger(DispatcherServlet.class);
	
	/**
	 * 处理Get.
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			
			doSTH(request, response, RequestType.GET);
		} catch (InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
			Console.Error(e);
		}
	}

	/**
	 * 处理PUT
	 */
	protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		responseUtil.getinstance().Write(response, "<p>what's wrong with u?</p>", "text/html");
//		try {
//			doSTH(request, response, RequestType.PUT);
//		} catch (InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
//			Console.Error(e);
//		}
	}

	/**
	 * 处理Post.
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			CrossCtrls.New().SetCrossDomain(request, response);
			
			doSTH(request, response, RequestType.POST);
		} catch (InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
			Console.Error(e);
		}
	}
	
	/**
	 * 处理Options。
	 */
	@Override
	protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			CrossCtrls.New().SetCrossDomain(request, response);
			
			doSTH(request, response, RequestType.OPTION);
		} catch (InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
			Console.Error(e);
		}
	}
	
//	@Override
//	protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
//		RequestContextHolder.setCurrentRequest(request);
//		String requrl = "";
//		requrl = request.getRequestURI().replaceFirst(request.getContextPath(), "");
//		Console.Info("requrl:" + requrl);
//		Console.Info("getRequestURI:" + request.getRequestURI());
//		// 这里从配置文件里面配？
//		
//		response.setHeader("Access-Control-Allow-Origin", "*");
//		response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
//		response.setHeader("Access-Control-Max-Age", "3600");
//		response.setHeader("Access-Control-Allow-Headers", "x-requested-with,Authorization");
//		response.setHeader("Access-Control-Allow-Credentials","true");
//		
//		boolean dispatched = false;
//		
//		List<IDispatcher> dispatchers = new ArrayList<>();
//		dispatchers.add(new MappingDispatcher());
//		dispatchers.add(new HoyiPageDispatcher());
//		dispatchers.add(new CustomFileDispatcher());
//		dispatchers.add(new WELCOMEDispatcher());
//		
//		for (IDispatcher _ddispatch : dispatchers) {
//			dispatched = _ddispatch.doSth(request, response, requrl, RequestType.OPTION);
//			if (dispatched) {
//				break;
//			}
//		}
//	}

	/**
	 * 处理请求
	 * 
	 * @param request
	 * @param response
	 * @param _reqType
	 *            请求类型.
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws ServletException
	 * @throws IOException
	 * @throws IllegalArgumentException
	 * @throws InvocationTargetException
	 * @throws ClassNotFoundException
	 */
	public void doSTH(HttpServletRequest request, HttpServletResponse response, RequestType _reqType) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
		RequestContextHolder.setCurrentRequest(request);
		String requrl = "";
		requrl = request.getRequestURI().replaceFirst(request.getContextPath(), "");
		if (this.ConsoleURL) {
			Console.Info("requrl:" + requrl);
		}
		
		boolean dispatched = false;
		
		List<IDispatcher> dispatchers = new ArrayList<>();
		dispatchers.add(new CustomFileDispatcher());
		dispatchers.add(new MappingDispatcher());
		dispatchers.add(new HoyiPageDispatcher());
		dispatchers.add(new PureForeDispatcher());
		
		dispatchers.add(new WELCOMEDispatcher());
		
		for (IDispatcher _ddispatch : dispatchers) {
			dispatched = _ddispatch.doSth(request, response, requrl, _reqType);
			if (dispatched) {
				break;
			}
		}

//		if (!dispatched) {
//			Console.Info("Can not find page." + requrl);
//			JsonModel model = new JsonModel(404, "NO Page Found");
//			responseUtil.getinstance().WriteUTF8JSON(response, model);
//		}
		
	}
	

}
