package org.hoyi.microservice.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 整个服务的API接口.
 * @author sam
 *
 */
public class APICons {
	
	private static APICons instance;
	
	public static APICons getInstance() {
		if (instance == null) {
			instance = new APICons();
		}
		return instance;
	}

	/**
	 * KEY,ModuleName,
	 * Value, CateName
	 * 必须分为 Module,Cates,API三级.
	 */
	public Map<String, List<String>> module_cates = new HashMap<>();
	
	/**
	 * KEY，CateName
	 * Value, API实体.
	 */
	public Map<String, List<APIEnti>> apis = new HashMap<>();
	
	/**
	 * 添加API
	 * @param module    主模块
	 * @param cates     子模块
	 * @param apiEnti   API
	 */
//	public void AddModule_Cate_API(String module, String cates, APIEnti apiEnti) {
//		module_cates.put(module, cates);
//		
//	}
	/**
	 * 添加API。
	 * @param cates   子模块
	 * @param apiEnti API 
	 */
	public void AddAPI(String module, String cates, APIEnti apiEnti) {
		List<String> cas = new ArrayList<>();
		if(module_cates.containsKey(module)) {
			cas = module_cates.get(module); 
		}
		if (!cas.contains(cates)) {
			cas.add(cates);
		}
		module_cates.put(module, cas);
		
		String key = module + "_" + cates;
		List<APIEnti> entis ;
		if(apis.containsKey(key)) {
			entis = apis.get(key);
		}else {
			entis = new ArrayList<>();
		}
		entis.add(apiEnti);
		apis.put(key, entis);
	}
	
	/**
	 * 根据主模块和子模块获取所有的API.
	 * @param module
	 * @param cates
	 * @return value
	 */
	public List<APIEnti> GetAPIs(String module, String cates){
		String key = module + "_" + cates;
		return apis.getOrDefault(key, null);
	}
	
	/**
	 * 获取模版内API的条数.
	 * @param module
	 * @param cates
	 * @return value
	 */
	public int GetAPIsCount(String module, String cates) {
		return GetAPIs(module, cates).size();
	}
	
	/**
	 * 获取
	 * @param module
	 * @param cates
	 * @param pagesize
	 * @param pageidx
	 * @return value
	 */
	public List<APIEnti> GetAPIs(String module, String cates, int pagesize, int pageidx){
		int startidx = (pageidx - 1) * pagesize;
		int endidx = pagesize * pageidx;

		List<APIEnti> apx = GetAPIs(module, cates);
		apx.subList(startidx, endidx);
		return apx;
	}
	
	/**
	 * 搜索接口，暂时置空
	 * @param modulelike
	 * @param cateslike
	 * @param apilike
	 * @param pagesize
	 * @param pageidx
	 * @return value
	 */
	public List<APIEnti> Search(String modulelike, String cateslike, String apilike, int pagesize, int pageidx){
		return null;
	}
	
}
