package org.hoyi.wb.comment.cache.hoyi;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * HOYI的方法缓存.
 * 只对方法名称缓存
 * 使用例子:
 * @HoyiCache(
				CachKey="actions.ords.ord_actions_" + "getOrderProDetil", 
				paramkeys = {"state","userid", "pgindex", "pagesize"},
				expiress = 1000 * 60 * 1 * 1  // 毫秒 * 秒 * 分 * 时 * 天
			)
 * @author ellen
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface HoyiCache {


	/**
	 * 缓存的KEYID.
	 * 一般默认用类名和方法名来确定，也可以自己定义.
	 * @return value
	 */
	String CachKey() default "";
	
	/**
	 * 需要判断是否相同的参数key值，相同的key就返回相同的值。
	 * @return value
	 */
	String[] paramkeys() default {};
	
	/**
	 * 缓存的时间，如果为-1，则一直存在..
	 * @return value
	 * 
	 */
	int expiress() default -1;
	
	
}
