package org.hoyi.websocket;

import org.eclipse.jetty.io.IdleTimeout;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.hoyi.DB.ctrl.Console;
import org.omg.CORBA._IDLTypeStub;

/**
 * 
 * websocketHandler.
 * 
 * Author:ellen Email:ellen@kuaifish.com 
 * CreateDate:2020-02-28
 * ModifyDate:2020-02-28 hoyi web @ hoyi.org 使用请在项目关于内标注hoyi版权，
 * hoyi版权归hoyi.org所有
 */
public class HoyiWebSocketHandler extends WebSocketHandler{
	
	/**
	 * 处理WebSocket的Handler类.
	 * 使用前将ListenterClass赋值就行，
	 * Demo： WebSocketListnerClass = MyWebSocketListener.class;
	 */
	public Class<?> WebSocketListenerClass = null;
	
	/**
	 * 处理的路径，这里设置后，将值交给contextHandler来判断是哪个路径处理的Handler.
	 * 默认值为/ws
	 * PS:值为/ws , 则请求的路径为 "ws://localhost/ws/"
	 */
	public String Req_Path = "";
	
	/**
	 * Handler的超时时间，默认为20000,初始化的时候可以初始超时值
	 */
	public int Idel_Timeout =  20000;
	
	/**
	 * 构造函数，构造Handler的时候初始化url, _websocketListenerClass.
	 * @param _url
	 * @param _websocketListenerClass
	 */
	public HoyiWebSocketHandler(String _req_path, Class<?> _websocketListenerClass) {
		Req_Path = _req_path;
		WebSocketListenerClass = _websocketListenerClass;
	}
	
	/**
	 * 构造函数，构造Handler的时候初始化url, _websocketListenerClass.
	 * @param _url
	 * @param _websocketListenerClass
	 */
	public HoyiWebSocketHandler(String _req_path, Class<?> _websocketListenerClass, int _IdelTimeout) {
		Req_Path = _req_path;
		WebSocketListenerClass = _websocketListenerClass;
		Idel_Timeout = _IdelTimeout;
	}
	
	@Override
	public void configure(WebSocketServletFactory factory) {
		// 注册
		if(WebSocketListenerClass != null) {
			factory.register(WebSocketListenerClass);
		}else {
			Console.Info("Register Socket Listener Error, Listener Class is Null!~");
		}
		factory.getPolicy().setIdleTimeout(Idel_Timeout);
		
		// 注册 下面的方法打开，注释上面的方法，可实现信息传输.
//		factory.register(MyWebSocketListener.class);
//		factory.getPolicy().setIdleTimeout(20000);
		
	}
}
