/*
 * Decompiled with CFR 0.152.
 */
package org.hoyi.microservice;

import java.util.ArrayList;
import java.util.List;
import org.hoyi.microservice.routes.model.HoyiProvider;
import org.hoyi.microservice.routes.model.HoyiRouter;

public class HoyiServiceManagement {
    private static HoyiServiceManagement _instance;
    List<HoyiProvider> services;
    List<HoyiRouter> routers;

    public static HoyiServiceManagement getInstance() {
        if (_instance == null) {
            _instance = new HoyiServiceManagement();
        }
        return _instance;
    }

    public List<HoyiProvider> getProviders() {
        if (this.services == null) {
            this.services = new ArrayList<HoyiProvider>();
        }
        return this.services;
    }

    public void setPoviders(List<HoyiProvider> services) {
        if (services == null) {
            services = new ArrayList<HoyiProvider>();
        }
        this.services = services;
    }

    public void AddProvider(HoyiProvider provider) {
        this.getProviders().add(provider);
    }

    public List<HoyiRouter> getRouters() {
        if (this.routers == null) {
            this.routers = new ArrayList<HoyiRouter>();
        }
        return this.routers;
    }

    public HoyiRouter getRouters(String ServiceID) {
        for (HoyiRouter router : HoyiServiceManagement.getInstance().getRouters()) {
            if (!router.getServiceID().equals(ServiceID)) continue;
            return router;
        }
        return null;
    }

    public void setRouters(List<HoyiRouter> routers) {
        this.routers = routers;
    }

    public void AddRouter(HoyiRouter router) {
        this.getRouters().add(router);
    }

    public List<HoyiProvider> GetProviderByID(String ServiceID) {
        ArrayList<HoyiProvider> providers = new ArrayList<HoyiProvider>();
        for (HoyiProvider provider : HoyiServiceManagement.getInstance().getProviders()) {
            if (!provider.getServiceID().equals(ServiceID)) continue;
            providers.add(provider);
        }
        return providers;
    }

    public List<HoyiProvider> GetProvider(String ServiceIDs) {
        List<HoyiProvider> providers = new ArrayList<HoyiProvider>();
        if (ServiceIDs.trim().length() > 0) {
            if (ServiceIDs.contains(",")) {
                String[] ids;
                for (String id : ids = ServiceIDs.split(",")) {
                    providers = HoyiServiceManagement.getInstance().GetProviderByID(id);
                }
            } else {
                providers = HoyiServiceManagement.getInstance().GetProviderByID(ServiceIDs);
            }
        }
        return providers;
    }
}

