package org.hoyi.configs.ctrls;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.hoyi.configs.HoyiWebConfig;

/**
 * 跨域孔子.
 * @author sam
 *
 */
public class CrossCtrls {
	
	private static CrossCtrls instance;
	
	public static CrossCtrls getInstance() {
		if(instance == null) {
			instance = new CrossCtrls();
		}
		return instance;
	}
	
	public static CrossCtrls New() {
		return new CrossCtrls();
	}
	
	/**
	 * 设置是否跨域.
	 * @param request
	 * @param response
	 */
	public void SetCrossDomain(HttpServletRequest request, HttpServletResponse response) {

		if(HoyiWebConfig.Allow_Cross_Domain) {
			// 配置成需要的时候再打开？
			if(HoyiWebConfig.Cross_Domain_TYPE.toLowerCase().equals("all")) {
				response.setHeader("Access-Control-Allow-Origin", "*");
			}else {
				response.setHeader("Access-Control-Allow-Origin", request.getHeader("origin"));
			}
			response.setHeader("Access-Control-Allow-Methods", HoyiWebConfig.Cross_Method);
			if(HoyiWebConfig.Cross_Allow_Credentials) {
				response.setHeader("Access-Control-Allow-Credentials", "true");
			}
		}
	}
}
