package org.hoyi.wb.comment.cache.redis;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * 
 * 只对方法名称缓存
 * @author ellen
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface RedisCache {


	/**
	 * 缓存的KEYID.
	 * 一般默认用类名和方法名来确定，也可以自己定义.
	 * @return value
	 */
	String CachKey() default "";
	
	/**
	 * 需要判断是否相同的参数key值，相同的key就返回相同的值。
	 * @return value
	 */
	String[] paramkeys() default {};
	
	/**
	 * 缓存的时间，如果为-1，则一直存在..
	 * @return value
	 * 
	 */
	int expiress() default -1;
	
	
}
