package WebRoot.hoyicloud.mds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.hoyi.dishop.Hoyipage;
import org.hoyi.microservice.HoyiServiceManagement;
import org.hoyi.microservice.configers.nginx.nginxConfExe;
import org.hoyi.microservice.routes.model.HoyiProvider;
import org.hoyi.microservice.routes.model.HoyiRouteRule;
import org.hoyi.microservice.routes.model.HoyiRouter;
import org.hoyi.wb.comment.PostParam;
import org.hoyi.wb.comment.RequestMode;
import org.hoyi.wb.comment.RequestType;
import org.hoyi.wb.comment.UnApiDoc;

@UnApiDoc
@RequestMode(MODE = { RequestType.GET, RequestType.POST })
public class servicelist extends Hoyipage {

	@PostParam(PARMS = {})
	@RequestMode(MODE = { RequestType.POST })
	public void PublishRoute() {
		nginxConfExe.getInstance().PublishRoute();
        
		String ret= "";
		this.WriteUTF8HTML("alert('config saved." + ret.toString() + "')");
	}

	@PostParam(PARMS = { "routeserviceid", "routerhost", "routeport", "notes" })
	@RequestMode(MODE = { RequestType.POST })
	public void AddRoute() {
		String routerid = getParams("routeserviceid");
		for (HoyiRouter router : HoyiServiceManagement.getInstance().getRouters()) {
			if (router.getServiceID().equals(routerid)) {
				this.WriteUTF8HTML("alert('ServiceID 已经存在！');");
				return;
			}
		}
		HoyiRouter router = new HoyiRouter();
		router.setUUID(UUID.randomUUID().toString());
		router.setServiceID(routerid);
		router.setHost(getParams("routerhost"));
		router.setPort(getParams("routeport"));
		router.setStatus("未知");
		router.setNotes(getParams("routenotes"));

		HoyiServiceManagement.getInstance().AddRouter(router);

		this.WriteUTF8HTML(
				"$('#routerbody').empty().append('" + GetRouterInfos() + "'); $('#modiModal').modal('hide');");
	}

	@PostParam(PARMS = { "ruleserviceID", "rulelocation", "proxypass", "localurl", "providers", "notes" })
	@RequestMode(MODE = { RequestType.POST })
	public void AddRules() {
		HoyiRouter router = HoyiServiceManagement.getInstance().getRouters(getParams("ruleserviceID"));

		HoyiRouteRule rule = new HoyiRouteRule();
		rule.setLocation(getParams("rulelocation"));
		rule.setProxyPass(getParams("proxypass"));
		rule.setLOCALURL(getParams("localurl"));
//		String providers = getParams("providers");
//		rule.setProviders(HoyiServiceManagement.getInstance().GetProvider(providers));
		rule.setProviderids(getParams("providers"));

		router.AddRule(rule);
		
		nginxConfExe.getInstance().PublishRoute();

		this.WriteUTF8HTML(
				"$('#routerbody').empty().append('" + GetRouterInfos() + "');$('#routemodal').modal('hide');");
	}

	public String GetRouterInfos() {
		String result = "";
		for (HoyiRouter router : HoyiServiceManagement.getInstance().getRouters()) {
			result += "<tr class=\"even gradeA\">";
			result += "	 <td>" + router.getServiceID() + "</td> ";
			result += "	 <td>" + router.getHost() + "</td> ";
			result += "	 <td>" + router.getPort() + "</td> ";
			result += "	 <td style=\"color: green;\">" + router.getStatus() + "</td> ";
			result += "	 <td  style=\"padding: 0px;\">";
			if (router.getRules().size() > 0)
				result += "<table width=\"100%\" class=\"table table-striped table-bordered table-hover\" id=\"dataTables-example\" style=\"margin: 0px; border-top: 0px;\">"
						+ "				<thead>" + "				<tr>" + "				<th>URL</th>"
						+ "				<th>Provider</th>" + "				<th></th>" + "			</tr>"
						+ "		</thead>" + "		<tbody>";
			for (HoyiRouteRule rules : router.getRules()) {
				result += "<tr class=\"even gradeA\">" + "		<td><a href=\"http://" + router.getHost() + ":"
						+ router.getPort() + rules.getLocation() + "\" target=\"_blank\" >" + rules.getLocation()
						+ "</a></td>" + "		<td>" + rules.getProviderids() + "&nbsp;" + rules.getProxyPass()
						+ "&nbsp;" + rules.getLOCALURL() + "</td>"
						+ "		<td><a class=\"label label-success\" style=\"padding: 4px; margin-right: 4px;\"> "
						+ "				<span class=\"glyphicon glyphicon-pencil\" style=\"color: white;\" aria-hidden=\"true\"></span> 添加服务"
						+ "		</a></td>" + "</tr>";
			}
			if (router.getRules().size() > 0)
				result += "</tbody></table>";
			result += "</td> ";
			result += "  <td>"
					+ "    <a class=\"label label-success\" style=\"padding: 4px; margin-right: 4px;\" serviceid=\""
					+ router.getServiceID() + "\" onclick=\"AddRouteRule(this);\"> "
					+ "         <span class=\"glyphicon glyphicon-pencil\" style=\"color: white;\" aria-hidden=\"true\"></span>"
					+ "         添加路由 " + "    </a>" + "   </td>" + "</tr>";
		}

		return result;
	}

	public String GetServiceInfo() {
		String string = "";

		Map<String, List<HoyiProvider>> servicemap = new HashMap<>();
		for (HoyiProvider service : HoyiServiceManagement.getInstance().getProviders()) {
			List<HoyiProvider> services = new ArrayList<>();
			if (servicemap.containsKey(service.getServiceID())) {
				services = servicemap.get(service.getServiceID());
			}
			services.add(service);
			servicemap.put(service.getServiceID(), services);
		}
		for (String _serkey : servicemap.keySet()) {
			string += "<tr class=\"even gradeA\">  <td>(UP)" + _serkey + "</td><td>";
			for (HoyiProvider _service : servicemap.get(_serkey)) {
				string += "<a target=\"_blank\" href=\"http://" + _service.getHost() + ":" + _service.getPort()
						+ "/index.html\">" + _service.getHost() + ":" + _service.getPort() + "</a>,";
			}
			string = string.substring(0, string.length() - 2);
			string += "</td><td>" + "	<a class=\"label label-success\" style=\"padding:4px;\"   >"
					+ "	    <span class=\"glyphicon glyphicon-pencil\" style=\"color:white;\" aria-hidden=\"true\"></span>  扩充服务"
					+ "	</a>" + "</td>";
			string += "</tr>";
		}
		return string;
	}

	/**
	 * 这里生成nginx.conf配置文件.
	 */
	@PostParam(PARMS = {})
	@RequestMode(MODE = { RequestType.POST })
	public void BuildConfigs() {
		String nginxconfig = nginxConfExe.getInstance().BuildAlertConfig();
		this.WriteUTF8HTML("$('#txnginxconfig').val(\"" + nginxconfig + "\");  $('#nginxconfmodal').modal('show');");
	}
}
