package org.hoyi.websocket;

import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.hoyi.DB.ctrl.Console;

/**
 * websocket处理方法. 这里是个例子，不做实际处理.
 * 这个方法建议自己重写WebSocketListener,不使用当前的方法。
 * 方法，创建自己的Listener继承自WebSocketListener。写自己的逻辑
 * 在创建HoyiWebSocketHandler的时候将Class设置成您创建的Listener就可以处理业务了。
 * 
 * Author:ellen Email:ellen@kuaifish.com 
 * CreateDate:2020-02-28
 * ModifyDate:2020-02-28 hoyi web @ hoyi.org 使用请在项目关于内标注hoyi版权，
 * hoyi版权归hoyi.org所有
 */
public class HoyiWebSocketListener implements WebSocketListener{

	public Session session;
	
	@Override
	public void onWebSocketClose(int statusCode, String reason) {
		Console.Info("on WebSocket Close");
		this.session = null;
	}

	@Override
	public void onWebSocketConnect(Session session) {
		Console.Info("onWebSocketConnect->" + session.getRemoteAddress());
		this.session = session;
	}

	@Override
	public void onWebSocketError(Throwable cause) {
		Console.Info("Error->" + cause.getMessage());
	}

	@Override
	public void onWebSocketBinary(byte[] payload, int offset, int len) {
		Console.Info("On WebSocket Binary");
	}

	@Override
	public void onWebSocketText(String message) {
		Console.Info("OnWebSocketText.收到消息.:" + message);
		if(session.isOpen()) {
			session.getRemote().sendString("echo msg 你收到了不->m" + message, null);
		}
	}

}
