package org.hoyi.websocket;

import java.util.HashMap;
import java.util.Map;

import javax.activation.MailcapCommandMap;

import org.eclipse.jetty.websocket.server.WebSocketHandler;

/**
 * websocket 配置.
 * 
 * Author:ellen Email:ellen@kuaifish.com 
 * CreateDate:2020-02-28
 * ModifyDate:2020-02-28 hoyi web @ hoyi.org 使用请在项目关于内标注hoyi版权，
 * hoyi版权归hoyi.org所有
 */
public class WebSocketConf {

	/**
	 * WebSocket 启动的类.
	 */
	public static Class<?> WebSocketListenerClass = null;
	
	/**
	 * WebSocket.超时时间.多久未操作，当前Socket就会断掉.
	 */
	public static int IdleTimeout = 20000;
	
	/**
	 * 默认WebSocket处理的路径.
	 */
	public static String DefWebSocketPath = "/ws";
	
	/**
	 * 处理WebSocket的路径和处理的Handler.
	 * Key,为路径，例如:/ws , 则请求的路径为 "ws://localhost/ws/"
	 * Value 为Handler, 新建一个类继承自 WebSocketHandler,服务器就会将指定的路径发送给指定的Handler.
	 * 
	 * 可使用的例子在hoyi-webs/src/org/hoyi/websocket内，
	 * MyWebSocketHandler,MyWebSocketListener是可以跑起来的例子，按照这样的方法创建处理方法就可以了。
	 * 
	 */
	public static Map<String, HoyiWebSocketHandler> WebSocketPathHandler = new HashMap<String, HoyiWebSocketHandler>();
	
	/**
	 * 设置超时时间.
	 * @param _IdleTimeout
	 */
	public static void SetIdleTimeout(int _IdleTimeout) {
		IdleTimeout = _IdleTimeout;
	}
	
	/**
	 * 设置处理WebSocket的Listener.
	 * @param _WebSocketListenerClass
	 */
	public static void SetWebSocketListenerClass(Class<?> _WebSocketListenerClass) {
		WebSocketListenerClass = _WebSocketListenerClass;
	}
}
