package org.hoyi.dishop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.hoyi.disptachs.model.JsonLibCtrls;
import org.hoyi.disptachs.model.fieldstr;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public abstract class HoyiVuePage extends Hoyipage {
	
	@Override
	public void OnPreInit() throws IOException {
		// TODO Auto-generated method stub
		this.setContainHoyiJS(false);
		this.setContainJQuery(false);
		super.OnPreInit();
	}
	
	public List<fieldstr> fieldstrs = new ArrayList<>();
	
	public abstract List<fieldstr> GetFields();
	
	public String GetInputers() {
		String retobj = "";
		for (fieldstr fieldx : GetFields()) {
			if(fieldx.isMakeel()) {
				retobj +=
						"    <div class=\"space-4\"></div>" + 
						"	 <div class=\"form-group\" " +(fieldx.isHideel()?"style=\"display:none;\"":"")+">" + 
						"	 <label class=\"col-sm-3 control-label no-padding-right\" for=\"form-field-1\" >" + fieldx.getChfield() + "</label>" + 
						"" + 
						"	 <div class=\"col-sm-9\">" + 
						"	 <input type=\"text\" name=\"" + fieldx.getEngfield() + "\" id=\"" + fieldx.getEngfield() + "\""
								+ " v-model=\"cur_"+fieldx.getEngfield() + "\"  "
								+ "placeholder=\"\" " +(fieldx.Required()?"required=\"\"":"")
								+" class=\"form-control col-xs-10 col-sm-5\" >" + 
						"	     <span class=\"help-inline col-xs-12 col-sm-7\">" + 
						"	       <span class=\"middle\"></span>" + 
						"	     </span>" + 
						"	  </div>" + 
						"	  </div>" ;
			}
		}
		return retobj;
	}
	/**
	 * 专门处理VUE返回的情况.
	 * @param _users
	 * @return value value
	 */
	public JSONObject RetJson(List<?> _users) {
		int pgindx = this.getPageIndex();
		JSONObject retdata = new JSONObject();
		retdata.put("pgsize", getpagesize());
		retdata.put("datacount", getDataCount());
		retdata.put("pgcount", getPageCount());
		/**
		 * modaltype, 弹出框的类型，
		 * 分为:showadd, hideadd, showupdate,hideupdate, showdel, hidedel, hideall;
		 * 每个值对应不同显示。
		 */
		retdata.put("modaltype", "none");
		retdata.put("filter", "");

		if (pgindx > this.getPageCount()) {
			retdata.put("curpgs", this.getPageCount());
		} else {
			retdata.put("curpgs", pgindx);
		}

		JSONArray usarr = JSONArray.fromObject(_users, JsonLibCtrls.getjsonConfig());
		retdata.put("curus", usarr);
		retdata.put("addmodelshow", true);

		for (fieldstr _fstr : GetFields()) {
			retdata.put("cur_" + _fstr.getEngfield(), "");
		}
		
		List<fieldstr> ff = GetFields();
		JSONArray far = JSONArray.fromObject(ff);
		retdata.put("fieldnames", far);

		return retdata;
	}
	
	/**
	 * 获取添加和修改的参数.
	 * @return value value
	 */
	public String ClearModiPara() {
		String retobj = "";
		for (fieldstr _fstr : GetFields()) {
			if(_fstr.isUpdateneed()) {
				retobj += "this.cur_"+_fstr.getEngfield()+" = '';\n";
			}
		}
		return retobj;
	}
	/**
	 * 获取添加和修改的参数.
	 * erase 是否清除对象
	 * true : this.cur_userid = '';
	 * false: "userid": this.cur_userid,
	 * 
	 * @return value value
	 */
	public String GetAddModiPara() {
		String retobj = "";
		for (fieldstr _fstr : GetFields()) {
			if(_fstr.isUpdateneed()) {
				retobj += "\""+_fstr.getEngfield()+"\": this.cur_"+_fstr.getEngfield()+",\n";
			}
		}
		return retobj;
	}
	
	public String GetModiMethod() {
		String retobj = "";
		String funcpara = "";
		String interpara = "";
		
		for (fieldstr _fstr : GetFields()) {
			if(_fstr.isUpdateneed()) {
				funcpara += _fstr.getEngfield() + ",";
				interpara += "this.cur_" +  _fstr.getEngfield() + " = " +  _fstr.getEngfield() + ";\n";
			}
		}
		
		funcpara = funcpara.substring(0, funcpara.length() -1);
		
		retobj += "MODI("+ funcpara+"){";
		retobj += interpara;
			
		retobj+="this.addmodelshow =  false;";
        retobj+=" $(\"#modiModal\").modal(\"show\");";
        retobj+="}";
        
		return retobj;
	}

	
	public String GetModiClickPara() {
		String retobj = "";
		String funcpara = "";
		
		for (fieldstr _fstr : GetFields()) {
			if(_fstr.isUpdateneed()) {
				funcpara += "us." + _fstr.getEngfield() + ",";
			}
		}
		
		funcpara = funcpara.substring(0, funcpara.length() -1);
		
//		retobj += "MODI("+ funcpara+")";
			
        
		return funcpara;
	}
	/**
	 * vue, vue-resource. 
	 * @return value
	 */
	public String VUELib(){
		return "" + 
				"	<!-- Vue.js -->" + 
				"	<script src=\"https://cdn.staticfile.org/vue/2.2.2/vue.min.js\"></script>" + 
				"	<script src=\"https://cdn.bootcss.com/vue-resource/1.5.1/vue-resource.min.js\"></script>";
	}
	
	/**
	 * BootstrapLib + VUE Lib
	 * @return value
	 */
	public String VUEBootStapLib() {
		return BootstrapLib() + VUELib();
	}
	
	/**
	 * 封装的，VUE Post 请求.
	 * 
	 * Hoyi_VUE_Post_URL
	 * Hoyi_VUE_Post
	 * 
	 * @return value
	 */
	public String HOYIVUEPostREQ() {
		return "function Hoyi_VUE_Post_URL(url,pdata,succfunc){Vue.http.post(url,pdata,{emulateJSON:true}).then(function(response){succfunc(response)},function(response){alert(\"req.http.error!~\")})}function Hoyi_VUE_Post(pdata,succfunc){Hoyi_VUE_Post_URL('',pdata,succfunc)}";
	}
}
