package org.hoyi.dispatchs;

import javax.servlet.http.HttpServletRequest;

/**
 *          Author:ellen
 *          Email:ellen@kuaifish.com
 *          CreateDate:2015-05-20
 *          ModifyDate:2015-06-20
 *          hoyi entities @ hoyi.org
 *          使用请在项目关于内标注hoyi版权，
 *          hoyi版权归hoyi.org所有
 */
public abstract class RequestContextHolder {
	private static final ThreadLocal<HttpServletRequest> REQUEST_THREAD_LOCAL = new ThreadLocal();

	public static HttpServletRequest getCurrentRequest() {
		return (HttpServletRequest) REQUEST_THREAD_LOCAL.get();
	}

	public static void setCurrentRequest(HttpServletRequest req) {
		REQUEST_THREAD_LOCAL.set(req);
	}
}
