package org.hoyi.hrpc;

import java.io.UnsupportedEncodingException;

import org.hoyi.DB.ctrl.Console;
import org.hoyi.dishop.Hoyipage;
import org.hoyi.util.HttpRequest;

/**
 * rpc.控制类.
 * 
 * @author sam
 *
 */
public class ctrls {
	
	/**
	 * 执行Get代理.
	 * @param _hpage
	 * @param ifacename
	 * @param curfacename
	 * @return value
	 */
	public Object Execute(Hoyipage _hpage, String ifacename, String curfacename) {
		HttpRequest httpRequest = new HttpRequest();
		String querystring = _hpage.getRequest().getQueryString();
		querystring = querystring.replace("behavior=" + curfacename, "behavior=" + ifacename);
		// 这里是否把HEADER信息也要发送过去.不然用户IP，Cookies数据信息将是错误的.
		String str = httpRequest.sendGet("http://localhost:8080/service1/LoginService.html", querystring);
		Console.Info("LoginService.html:" + str);
		return str;
	}
	
	/**
	 * 执行Post代理.
	 * @param _hpage
	 * @param ifacename
	 * @param curfacename
	 * @return value
	 */
	public Object ExecutePost(Hoyipage _hpage, String ifacename, String curfacename) {
		String str = "";
		try {
			HttpRequest httpRequest = new HttpRequest();
			String querystring = httpRequest.getPostQueryString(_hpage);
			querystring = querystring.replace("behavior=" + curfacename, "behavior=" + ifacename);
			
			// 这里是否把HEADER信息也要发送过去.
			str = httpRequest.sendPost("http://localhost:8080/service1/LoginService.html", querystring);

			Console.Info("LoginService.html:" + str);
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return str;
	}
	
	/**
	 * 执行Post代理.
	 * @param _hpage
	 * @param behaviorName
	 * @return value
	 */
	public Object ExecutePost(Hoyipage _hpage, String behaviorName) {
		String str = "";
		try {
			HttpRequest httpRequest = new HttpRequest();
			String querystring = httpRequest.getPostQueryString(_hpage);
//			querystring = querystring.replace("behavior=" + curfacename, "behavior=" + ifacename);
			querystring = "&behavior=" + behaviorName + "&" + querystring;
			
			// 这里是否把HEADER信息也要发送过去.
			str = httpRequest.sendPost("http://localhost:8080/service1/LoginService.html", querystring);

			Console.Info("LoginService.html:" + str);
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return str;
	}
	
}
