package org.hoyi.initers;

import org.hoyi.DB.conf.HOYIConf;
import org.hoyi.DB.ctrl.Console;
import org.hoyi.microservice.HoyiCloudApplication;
import org.hoyi.staticcache.HoyiPageStaticCache;

/**
 * hoyi web 的初始化.
 * @author sam
 *
 */
public class HoyiWebIniters {
	
	private static HoyiWebIniters _instance;

	public static HoyiWebIniters getInstance() {
		if (_instance == null) {
			_instance = new HoyiWebIniters();
		}
		return _instance;
	}
	
	/**
	 * 初始化 hoyi web 
	 */
	public void Init() {
		/**
		 * 执行静态缓存HoyiPage
		 */
		if(HOYIConf.PageCache) {
			HoyiPageStaticCache.getInstance().BeginStaticCache();
		}
		
		//Console.Info("Initied hoyi cloud app finished, port:" + HoyiCloudApplication.REQ_PORT);
	}
	
	/**
	 * 清除hoyi web的初始化.
	 */
	public void Close() {
		HoyiPageStaticCache.getInstance().ClearMaps();
	}

}
