package org.hoyi.microservice.routes.model;

import java.util.List;

/**
 * 路由规则。
 * @author sam
 *
 */
public class HoyiRouteRule {
	
	/**
	 * 路径规则,
	 * 对应： location ^~ /static/  的  ^~ /static/
	 *       location ~* \.(gif|jpg|jpeg|png|css|js|ico)$  里的  ~* \.(gif|jpg|jpeg|png|css|js|ico)$ 
	 *       完全使用nginx的语法.
	 */
	String Location;
	
	/**
	 * 转发的HTTP，如果为空则无这类规则
	 * location / {}内的内容
	 */
	String ProxyPass;
	
	/**
	 * 本地文件路径，如为空则无这类规则
	 * location / {}内的内容
	 */
	String LOCALURL;
	
	String providerids;
	
	/**
	 * 路由提供的服务供应器，如为空则无这类规则.
	 * location / {}内的内容
	 */
	//List<HoyiProvider> providers;

	public String getLocation() {
		return Location;
	}

	public void setLocation(String location) {
		Location = location;
	}

	public String getProxyPass() {
		return ProxyPass;
	}

	public void setProxyPass(String proxyPass) {
		ProxyPass = proxyPass;
	}

	public String getLOCALURL() {
		return LOCALURL;
	}

	public void setLOCALURL(String lOCALURL) {
		LOCALURL = lOCALURL;
	}

	public String getProviderids() {
		return providerids;
	}

	public void setProviderids(String providerids) {
		this.providerids = providerids;
	}

//	public List<HoyiProvider> getProviders() {
//		return providers;
//	}
//
//	public void setProviders(List<HoyiProvider> providers) {
//		this.providers = providers;
//	}
	
	/**
	 * 获取供应者的ID列表.
	 * @return
	 */
//	public String GetServiceIDs() {
//		String serviceids = "";
//		for (HoyiProvider hoyiProvider : getProviders()) {
//			serviceids += hoyiProvider.getServiceID() + ",";
//		}
//		if (serviceids.length() > 0 && serviceids.endsWith(",")) {
//			serviceids = serviceids.substring(0, serviceids.length() - 1);
//		}
//		return serviceids;
//	}
	
}
