package org.hoyi.wb.comment.cache.redis;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 
 * 调用后，接口调用的次数+1， 存入Redis.
 * @author ellen
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface RedisIncr {

	/**
	 * 自增的KEYID.
	 * 一般默认用类名和方法名来确定，也可以自己定义.
	 * @return value
	 */
	String IncrKey() default "";
	
}
