/*
 * Decompiled with CFR 0.152.
 */
package org.hoyi.microservice.configers.nginx;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.hoyi.microservice.HoyiCloudApplication;
import org.hoyi.microservice.HoyiServiceManagement;
import org.hoyi.microservice.routes.model.HoyiProvider;
import org.hoyi.microservice.routes.model.HoyiRouteRule;
import org.hoyi.microservice.routes.model.HoyiRouter;

public class nginxConfExe {
    private static nginxConfExe _instance;

    public static nginxConfExe getInstance() {
        if (_instance == null) {
            _instance = new nginxConfExe();
        }
        return _instance;
    }

    public void PublishRoute() {
        String nginxconfig = nginxConfExe.getInstance().BuildConfig();
        String configpath = HoyiCloudApplication.hoyiconfig.getNGINX().get("CONF-URL");
        nginxConfExe.getInstance().SaveConfig(nginxconfig, configpath);
        String baturl = HoyiCloudApplication.hoyiconfig.getNGINX().get("SHELL-URL");
        nginxConfExe.getInstance().runbat(baturl);
    }

    public void runbat(String baturl) {
        String cmd = "cmd /C start /b " + baturl;
        try {
            Process ps = Runtime.getRuntime().exec(cmd);
            InputStream in = ps.getInputStream();
            in.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        System.out.println("child thread donn");
    }

    public static String runShell(String shStr, String ostype) throws Exception {
        Process process = ostype.toUpperCase().equals("WINDOWS") ? Runtime.getRuntime().exec(new String[]{"cmd", "-c", shStr}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", shStr});
        process.waitFor();
        BufferedReader read = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = null;
        String result = "";
        while ((line = read.readLine()) != null) {
            result = result + line;
        }
        return result;
    }

    public static Object exec(String cmd) {
        try {
            String line;
            String[] cmdA = new String[]{"/bin/sh", "-c", cmd};
            Process process = Runtime.getRuntime().exec(cmdA);
            LineNumberReader br = new LineNumberReader(new InputStreamReader(process.getInputStream()));
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                System.out.println(line);
                sb.append(line).append("\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SaveConfig(String configcontent, String path) {
        FileWriter fwriter = null;
        try {
            fwriter = new FileWriter(path);
            fwriter.write(configcontent);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                fwriter.flush();
                fwriter.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void AL(StringBuilder stringBuilder, String content) {
        stringBuilder.append(content + "\n");
    }

    public void AX(StringBuilder stringBuilder, String content) {
        stringBuilder.append(content + "\n\n");
    }

    public String BuildAlertConfig() {
        String config = this.BuildConfig();
        config = config.replaceAll("\n", "\\\"+'\\\\n'+\\\"");
        return config;
    }

    public String BuildConfig() {
        StringBuilder sb = new StringBuilder();
        StringBuilder upstream = new StringBuilder();
        ArrayList<StringBuilder> upstreambuilders = new ArrayList<StringBuilder>();
        ArrayList<String> upstridexed = new ArrayList<String>();
        this.AL(sb, "#user root owner;");
        this.AL(sb, "worker_processes  1;");
        this.AL(sb, "   ");
        this.AL(sb, "#error_log  logs/error.log;");
        this.AL(sb, "#error_log  logs/error.log notice;");
        this.AX(sb, "#error_log  logs/error.log; info");
        this.AL(sb, "events {");
        this.AL(sb, "    worker_connections  1024;");
        this.AX(sb, "}");
        this.AX(sb, "http {");
        this.AL(sb, "\tinclude       mime.types;");
        this.AX(sb, "\tdefault_type  application/octet-stream;");
        this.AL(sb, "\tsendfile        on;");
        this.AL(sb, "\t#tcp_nopush     on;");
        this.AL(sb, "\t#keepalive_timeout  0;");
        this.AX(sb, "\tkeepalive_timeout  65;");
        this.AL(sb, "   \t#gzip  on;");
        for (HoyiRouter router : HoyiServiceManagement.getInstance().getRouters()) {
            this.AL(sb, "\tserver {");
            this.AL(sb, "\t\t\tlisten       " + router.getPort() + ";");
            this.AX(sb, "\t\t\tserver_name  " + router.getHost() + ";");
            for (HoyiRouteRule rules : router.getRules()) {
                this.AL(sb, "\t\t\tlocation " + rules.getLocation() + " {");
                if (rules.getLOCALURL() != null && rules.getLOCALURL().trim().length() > 0) {
                    this.AL(sb, "\t\t\t\t" + rules.getLOCALURL() + ";");
                }
                if (rules.getProxyPass() != null && rules.getProxyPass().trim().length() > 0) {
                    this.AL(sb, "\t\t\t\tproxy_pass   " + rules.getProxyPass() + ";");
                    this.AL(sb, "\t\t\t\tproxy_set_header Host $host;");
                }
                upstream = new StringBuilder();
                if (rules.getProviderids() != null && rules.getProviderids().trim().length() > 0) {
                    List<HoyiProvider> streamproviders = HoyiServiceManagement.getInstance().GetProvider(rules.getProviderids());
                    String curserviceid = streamproviders.get(0).getServiceID();
                    this.AL(sb, "\t\t\t\tproxy_pass   http://" + curserviceid + "/;");
                    if (streamproviders.size() > 0 && !upstridexed.contains(curserviceid)) {
                        if (streamproviders.size() > 0) {
                            this.AL(upstream, "\tupstream " + curserviceid + "{");
                        }
                        for (HoyiProvider _provider : streamproviders) {
                            this.AL(upstream, "\t\tserver " + _provider.getHost() + ":" + _provider.getPort() + " weight=1;");
                        }
                        if (streamproviders.size() > 0) {
                            this.AX(upstream, "\t}");
                        }
                        upstridexed.add(curserviceid);
                    }
                }
                upstreambuilders.add(upstream);
                this.AX(sb, "\t\t\t}");
            }
            this.AX(sb, "\t}");
        }
        for (StringBuilder _stringBuilder : upstreambuilders) {
            sb.append(_stringBuilder.toString());
        }
        this.AL(sb, "}");
        return sb.toString();
    }
}

