package WebRoot.hoyicloud.mds;

import java.io.IOException;
import java.util.UUID;

import org.hoyi.dishop.Hoyipage;
import org.hoyi.microservice.HoyiCloudApplication;
import org.hoyi.microservice.HoyiServiceManagement;
import org.hoyi.microservice.routes.model.HoyiProvider;
import org.hoyi.wb.comment.UnApiDoc;

@UnApiDoc
public class machinelist extends Hoyipage{
	
	@Override
	public void OnPreInit() throws IOException {
		// 服务类型
		String SERVICETYPE = HoyiCloudApplication.hoyiconfig.getSERVICE().getOrDefault("SERVICE-TYPE", "PROVIDER");
		if(!"PROVIDER".equals(SERVICETYPE)){
			super.OnPreInit();	
		}
	}
	
	public void RegisterService() {
		String serviceID = this.getParams("serviceid");
		String host = this.getParams("host");
		String port = this.getParams("port");
		
		HoyiProvider service = new HoyiProvider(host, port, serviceID, UUID.randomUUID().toString());
		HoyiServiceManagement.getInstance().getProviders().add(service);
		this.WriteUTF8JSONDATAMSG(201, "服务提供注册成功", null);
	}
	
	public String GetServiceInfo() {
		/**
		 * 
                                    <tr class="even gradeA">
                                        <td>Trident</td>
                                        <td>Internet Explorer 6</td>
                                        <td>Win 98+</td>
                                        <td class="center">6</td>
                                        <td class="center">A</td>
                                    </tr>
		 */
		String string = "";
		for (HoyiProvider service : HoyiServiceManagement.getInstance().getProviders()) {
			string += "<tr class=\"even gradeA\">\n" + 
"                                        <td>" + service.getHost() + "</td>\n" + 
"                                        <td>"+service.getPort() +"</td>\n" + 
"                                        <td>" + service.getServiceID()+ "</td>\n" + 
"                                        <td class=\"center\">" + service.getServiceUUID() + "</td>\n" + 
"                                        <td class=\"center\"></td>\n" + 
"                                        <td class=\"center\"></td>\n" + 
"                                        <td>"
+ "                         <a class=\"label label-success\" style=\"padding:4px;\">" + 
"					            <span class=\"glyphicon glyphicon-pencil\" style=\"color:white;\" aria-hidden=\"true\"></span>  \n" + 
"						    </a></td>\n" + 
"                      </tr>";
		}
		return string;
	}

}
