package org.hoyi.sessionlisten;

import org.hoyi.DB.ctrl.Console;
import org.hoyi.dispatchs.DispatchConfig;
import org.hoyi.initer.HoyiEntitiesIniter;
import org.hoyi.initers.HoyiWebIniters;
import org.hoyi.microservice.HoyiCloudApplication;

/**
 * @author sam
 *
 */
public class SessionIniter {
	
	private static SessionIniter _instance;
	
	public static SessionIniter getInstance() {
		if(_instance == null) {
			_instance = new SessionIniter();
		}
		return _instance;
	}
	
	/**
	 * 应用销毁时调用
	 */
	public void contextDestroyed() {
		// TODO Auto-generated method stub
		Console.Info("context destroyed.");
		
		HoyiEntitiesIniter.getInstance().Close();
	}

	/**
	 * 应用初始化时调用.
	 */
	public void contextInitialized() {
		
		DispatchConfig.beginstarttime = System.currentTimeMillis();
		
		/**
		 * 初始化HoyiEntities。
		 */
		HoyiEntitiesIniter.getInstance().InitConcig();
		
		/**
		 * 初始化HoyiWeb
		 */
		HoyiWebIniters.getInstance().Init();
		
		DispatchConfig.finishstarttime = System.currentTimeMillis();
		
		Console.Info("");
		Console.Info("hoyi cloud app started .on port:" + HoyiCloudApplication.REQ_PORT  + " [if micservice] . time:" + (DispatchConfig.finishstarttime - DispatchConfig.beginstarttime) + "ms");    //输出程序运行时间
		/**
		 * 弹出浏览器，打开网址。
		 */
//		String url = "http://localhost:" + HoyiCloudApplication.REQ_PORT+"/index.html";
//		try {
//			OpenExplorerUtil.browse(url);
//		} catch (Exception e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
	}

}
