package org.hoyi.web.ctrls;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;

import org.hoyi.DB.ctrl.Console;
import org.hoyi.DB.ents.Entity;
import org.hoyi.DB.model.DataRow;
import org.hoyi.util.CutStrInfo;
import org.hoyi.util.Util;

import net.sf.json.JSONObject;

/**
 *          Author:ellen
 *          Email:ellen@kuaifish.com
 *          CreateDate:2015-05-20
 *          ModifyDate:2015-06-20
 *          hoyi entities @ hoyi.org
 *          使用请在项目关于内标注hoyi版权，
 *          hoyi版权归hoyi.org所有
 */
public class Repeater extends IHoyiCtrl
{
  public Boolean AutoGenerateColumn = Boolean.valueOf(false);
  public String HeaderTemplate;
  public String ItemTemplate;
  public String SeparatorTemplate;
  public String ItemTOFooter;
  public String FooterTemplate;
  public String NoneDataTemplate;
  
  String REPHEADER = "<hoyip:Repeater";
  String REPEND = "</hoyip:Repeater>";
  String HEADERTEMPLATE_HEADER = "<HeaderTemplate>";
  String HEADERTEMPLATE_END = "</HeaderTemplate>";
  String ITEMTEMPLATE_HEADER = "<ItemTemplate>";
  String ITEMTEMPLATE_END = "</ItemTemplate>";
  String SEPARATORTEMPLATE_HEADER = "<SeparatorTemplate>";
  String SEPARATORTEMPLATE_END = "</SeparatorTemplate>";
  String FOOTERTEMPLATE_HEADER = "<FooterTemplate>";
  String FOOTERTEMPLATE_END = "</FooterTemplate>";
  
  /**
   *  数据源个数为零时候的模板.
   */
  String NONEDATATEMPLATE_HEAD = "<NoneDataTemplate>";
  String NONEDATATEMPLATE_END = "</NoneDataTemplate>";
  
  String ItemTOFooter_HEADER = "<ItemTOFooter>";
  String ItemTOFooter_END = "</ItemTOFooter>";

  String PAGING_HEADER = "<Paging>";
  String PAGING_END = "</Paging>";
  String PagiCustom_HEADER = "<PagiCustom>";
  String PagiCustom_END = "</PagiCustom>";
  String PagiCurrent_HEADER = "<PagiCurrent>";
  String PagiCurrent_END = "</PagiCurrent>";
  
  public static String FooterStyle = "B";
  public static int pageNum = 10;

  public Repeater(String ctrid)
  {
    super(ctrid);
  }

  public Repeater(String ctrid, IHoyiCtrl parent)
  {
    super(ctrid, parent);
  }

  public String getId()
  {
    return super.getId();
  }

  public void setId(String id)
  {
    super.setId(id);
  }

  public String InitContentByTemplates(String _template)
  {
    String repHeader = this.REPHEADER + " Id=\"" + getId() + "\"";

    CutStrInfo strInfo = new CutStrInfo(repHeader, this.REPEND);
    boolean contain = strInfo.Calc(_template);
    if (contain) {
      setHtmlContent(strInfo.getEXPREDContent());
      this.rendedHTMLContent = strInfo.getEXPREDContent();
      CutStrInfo headerInfo = new CutStrInfo(this.HEADERTEMPLATE_HEADER, this.HEADERTEMPLATE_END, getHtmlContent());
      CutStrInfo itemInfo = new CutStrInfo(this.ITEMTEMPLATE_HEADER, this.ITEMTEMPLATE_END, getHtmlContent());
      CutStrInfo item2footinfo = new CutStrInfo(this.ItemTOFooter_HEADER, this.ItemTOFooter_END, getHtmlContent());
      CutStrInfo footinfo = new CutStrInfo(this.FOOTERTEMPLATE_HEADER, this.FOOTERTEMPLATE_END, getHtmlContent());
      CutStrInfo nonedatainfo = new CutStrInfo(this.NONEDATATEMPLATE_HEAD, this.NONEDATATEMPLATE_END, getHtmlContent());
      
      headerInfo.Calc(false);
      itemInfo.Calc(false);
      item2footinfo.Calc(false);
      footinfo.Calc(false);
      nonedatainfo.Calc(false);

      this.HeaderTemplate = headerInfo.getEXPREDContent();
      this.ItemTemplate = itemInfo.getEXPREDContent();
      this.ItemTOFooter = item2footinfo.getEXPREDContent();
      this.FooterTemplate = footinfo.getEXPREDContent();
      this.NoneDataTemplate = nonedatainfo.getEXPREDContent();
      
      Console.Info("HeaderTemplate:" + this.HeaderTemplate);
      Console.Info("ItemTemplate:" + this.ItemTemplate);
      Console.Info("ItemTOFooter:" + this.ItemTOFooter);
      Console.Info("FooterTemplate:" + this.FooterTemplate);
      Console.Info("NoneDataTemplate:" + this.NoneDataTemplate);
    }
    return this.HtmlContent;
  }

  public boolean ContainMethod(Method[] method, String methodName) {
    for (Method md : method) {
      if (md.getName().equals(methodName)) {
        return true;
      }
    }
    return false;
  }

  public String Render()
  {
    return RenderT(this.HtmlContent);
  }

  public String RenderT(String Template)
  {
    String neirong = "";

    if (this.EntitySource != null) {
      for (Iterator localIterator = this.EntitySource.iterator(); localIterator.hasNext(); ) { Object ent = localIterator.next();
        neirong = neirong + TransEnts(this.ItemTemplate, (Entity)ent);
      }
    }
    Object tmpobj = null;
    if (this.TableSource != null) {
      for (int i = 0; i < this.TableSource.RowsCount(); i++) {
        neirong = neirong + TransField(this.ItemTemplate, this.TableSource.getRow(i), i);
      }
    }
    
    if(this.JsonSource != null) {
    	for (int i = 0; i < JsonSource.size(); i++) {
    		neirong = neirong + TransJSONField(this.ItemTemplate, JsonSource.getJSONObject(i), i);
		}
    }

    String Footer = ""; String Header = "";
    if (this.FooterTemplate != null) {
      Footer = TransFooter(this.FooterTemplate);
    }
    if (this.HeaderTemplate != null) {
      Header = this.HeaderTemplate;
    }

    this.rendedHTMLContent = (Header + neirong + ItemTOFooter + Footer);
    this.rendedHTMLContent = TransEXCUTEMethod(this.rendedHTMLContent);
    
    if ((this.EntitySource == null ||(this.EntitySource != null && this.EntitySource.size() <= 0)) && (this.TableSource == null ||(this.TableSource != null && this.TableSource.RowsCount() <= 0)) && (this.JsonSource == null ||(this.JsonSource != null && this.JsonSource.size() <= 0))) {
    	this.rendedHTMLContent = NoneDataTemplate;
	}
    
    return this.rendedHTMLContent;
  }

  public String TransFooter(String _template)
  {
    if ((_template != null) && (getDataCount() > 0)) {
      CutStrInfo pagi = new CutStrInfo(this.PAGING_HEADER, this.PAGING_END, _template);
      boolean contain = pagi.Calc(false);
      if (contain)
      {
        String cureentstr = ""; String resultStr = ""; String pagingStr = "";
        CutStrInfo custom = new CutStrInfo(this.PagiCustom_HEADER, this.PagiCustom_END, pagi.getEXPREDContent());
        custom.Calc(false);
        CutStrInfo current = new CutStrInfo(this.PagiCurrent_HEADER, this.PagiCurrent_END, pagi.getEXPREDContent());
        current.Calc(false);
        CalcPageCount(this.DataCount, getPageSize());

        switch (Repeater.FooterStyle) {
			case "A":
			       for (int i = 0; i < getPageCount(); i++) {
	//		         for (int i = 0; i < 10; i++) {
	//		         for(int i = this.PageIndex + 5; i< this.PageCount - this.PageIndex + 5; i ++){
			           if (i + 1 == this.PageIndex)
			             cureentstr = cureentstr + current.getEXPREDContent().replace("{# pageindex #}", String.valueOf(i + 1));
			           else {
			             cureentstr = cureentstr + custom.getEXPREDContent().replace("{# pageindex #}", String.valueOf(i + 1));
			           }
	
			         }
				break;
			case "B":
				
				int pgIndex = this.PageIndex;
				int pgCount =  getPageCount();
				if(pgCount > pageNum){
					int halfPage = (int)Math.floor(pageNum / 2.0);
					if(pgIndex > halfPage){//不做处理
						pgCount = pgIndex + halfPage;
						if(pgCount > getPageCount()){
							pgCount = getPageCount();
							if(pgIndex > pgCount - halfPage){
								pgIndex = pgCount - pageNum + 1;
							}
						}else{
							pgIndex = pgIndex - halfPage;
						}
						
					}else{
						pgCount = pageNum;
						pgIndex = 1;
					}
				}else{
					pgIndex = 1;
				}
	//		         for (int i = 0; i < 10; i++) {
				for(int i = pgIndex - 1; i< pgCount; i ++){
			           if (i + 1 == this.PageIndex)
			             cureentstr = cureentstr + current.getEXPREDContent().replace("{# pageindex #}", String.valueOf(i + 1));
			           else {
			             cureentstr = cureentstr + custom.getEXPREDContent().replace("{# pageindex #}", String.valueOf(i + 1));
			           }
	
			         }
				break;
			case "C":
				break;
		default:
			  for (int i = 0; i < getPageCount(); i++) {
					//		         for (int i = 0; i < 10; i++) {
					//		         for(int i = this.PageIndex + 5; i< this.PageCount - this.PageIndex + 5; i ++){
							           if (i + 1 == this.PageIndex)
							             cureentstr = cureentstr + current.getEXPREDContent().replace("{# pageindex #}", String.valueOf(i + 1));
							           else {
							             cureentstr = cureentstr + custom.getEXPREDContent().replace("{# pageindex #}", String.valueOf(i + 1));
							           }
					
							         }
			break;
		}
 

        pagingStr = _template.replace(this.PAGING_HEADER + pagi.getEXPREDContent() + this.PAGING_END, cureentstr);

        resultStr = pagingStr.replace("{# pagecount #}", String.valueOf(getPageCount()));

        return resultStr;
      }
    }
    System.out.println("Template is NULL");

    return "";
  }

  public String TransField(String Template, DataRow dr, int j)
  {
    if ((Template == null) || (Template == "")) {
      System.out.println("TransField  Template is NULL");
      return Template;
    }

    for (int i = 0; i < dr.getColumns().size(); i++) {
      String FieldName = dr.getColumn(i).ColumnName;
      String value = dr.GetData(i) != null ? dr.GetData(i).toString() : "";

      Template = Template.replace("{# " + FieldName + " #}", value);
    }
    Template = TransEXCUTEMethod(Template);
    return Template;
  }
  
  public String TransJSONField(String Template, JSONObject obj, int j)
  {
    if ((Template == null) || (Template == "")) {
      System.out.println("TransField  Template is NULL");
      return Template;
    }
    Iterator<String> it = obj.keys();
    while (it.hasNext()) {
    	// 获得key
    	String FieldName = it.next(); 
    	String value = obj.getString(FieldName);  
    	
    	Template = Template.replace("{# " + FieldName + " #}", value);
		
	}
    Template = TransEXCUTEMethod(Template);
    return Template;
  }

  public String TransEnts(String Template, Entity ent) {
    if ((Template == null) || (Template == "")) {
      System.out.println("TransEnts  Template is NULL");
      return Template;
    }

    Field[] fields = ent.getClass().getDeclaredFields();

    for (Field field : fields) {
      Method[] method = ent.getClass().getMethods();
      for (Method md : method) {
        if (md.getName().equals("get" + Util.FirstUpToParscal(field.getName()))) {
          try
          {
            Object objtmp = md.invoke(ent, new Object[0]);

            if (objtmp != null) {
              String objtmp2 = objtmp.toString();
              String valifield = "{# " + field.getName() + " #}";
              Template = Template.replace(valifield, objtmp2);
            }

          }
          catch (IllegalAccessException|IllegalArgumentException|InvocationTargetException e)
          {
          	Console.Error(e);
          }
        }
      }
    }
    Template = TransEXCUTEMethod(Template);
    return Template;
  }
}

