/*
 * Decompiled with CFR 0.152.
 */
package org.hoyi.microservice.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hoyi.microservice.api.model.APIEnti;

public class APICons {
    private static APICons instance;
    public Map<String, List<String>> module_cates = new HashMap<String, List<String>>();
    public Map<String, List<APIEnti>> apis = new HashMap<String, List<APIEnti>>();

    public static APICons getInstance() {
        if (instance == null) {
            instance = new APICons();
        }
        return instance;
    }

    public void AddAPI(String module, String cates, APIEnti apiEnti) {
        List<String> cas = new ArrayList<String>();
        if (this.module_cates.containsKey(module)) {
            cas = this.module_cates.get(module);
        }
        if (!cas.contains(cates)) {
            cas.add(cates);
        }
        this.module_cates.put(module, cas);
        String key = module + "_" + cates;
        List<APIEnti> entis = this.apis.containsKey(key) ? this.apis.get(key) : new ArrayList<APIEnti>();
        entis.add(apiEnti);
        this.apis.put(key, entis);
    }

    public List<APIEnti> GetAPIs(String module, String cates) {
        String key = module + "_" + cates;
        return this.apis.getOrDefault(key, null);
    }

    public int GetAPIsCount(String module, String cates) {
        return this.GetAPIs(module, cates).size();
    }

    public List<APIEnti> GetAPIs(String module, String cates, int pagesize, int pageidx) {
        int startidx = (pageidx - 1) * pagesize;
        int endidx = pagesize * pageidx;
        List<APIEnti> apx = this.GetAPIs(module, cates);
        apx.subList(startidx, endidx);
        return apx;
    }

    public List<APIEnti> Search(String modulelike, String cateslike, String apilike, int pagesize, int pageidx) {
        return null;
    }
}

