/*
 * Decompiled with CFR 0.152.
 */
package org.hoyi.staticcache;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.hoyi.DB.comment.DbAttrANNO;
import org.hoyi.DB.conf.HOYIConf;
import org.hoyi.DB.ctrl.Console;
import org.hoyi.DB.ents.Entity;
import org.hoyi.dispatchs.DispatchConfig;
import org.hoyi.disptachs.model.JsonLibCtrls;
import org.hoyi.microservice.HoyiCloudApplication;
import org.hoyi.microservice.api.anno.ApiEntityPara;
import org.hoyi.microservice.api.anno.ApiPara;
import org.hoyi.microservice.api.anno.Apidoc;
import org.hoyi.microservice.api.model.APICons;
import org.hoyi.microservice.api.model.APIEnti;
import org.hoyi.microservice.api.model.APIPara;
import org.hoyi.staticcache.PackageClassUtil2;
import org.hoyi.staticcache.ReqMapInfo;
import org.hoyi.wb.comment.RequestMethod;
import org.hoyi.wb.comment.RequestMode;
import org.hoyi.wb.comment.UnApiDoc;

public class HoyiPageStaticCache {
    private static HoyiPageStaticCache _instance;
    public Map<String, String> Modules = new HashMap<String, String>();
    public Map<String, Class<?>> hoyipagescache = new HashMap();
    public Map<String, ReqMapInfo> reqmapping = new HashMap<String, ReqMapInfo>();
    public boolean StaticCahced = false;

    public static HoyiPageStaticCache getInstance() {
        if (_instance == null) {
            _instance = new HoyiPageStaticCache();
        }
        return _instance;
    }

    public void BeginStaticCache() {
        String packageName = "WebRoot";
        DispatchConfig.ConsoleMapping = Boolean.parseBoolean(HoyiCloudApplication.hoyiconfig.getHOYI().getOrDefault("ConsoleMapping", "false"));
        try {
            Set<Class<?>> Classes = PackageClassUtil2.getClasses(packageName);
            String tmpclass = "";
            if (Classes != null) {
                String classModule = "";
                String classCates = "";
                for (Class<?> curclass : Classes) {
                    if (curclass.getName().startsWith("WebRoot.")) {
                        tmpclass = curclass.getName().substring(8, curclass.getName().length());
                        tmpclass = tmpclass.replace(".", "/");
                    }
                    this.hoyipagescache.put(tmpclass, curclass);
                    if (DispatchConfig.ConsoleMapping) {
                        Console.Info((String)("tmpclass:" + tmpclass));
                    }
                    ReqMapInfo _pgmapinfos = new ReqMapInfo();
                    _pgmapinfos.reqclass = curclass;
                    _pgmapinfos.pgreq = true;
                    _pgmapinfos.requrl = "/" + tmpclass + HOYIConf.Suffix;
                    _pgmapinfos.reqmethods = null;
                    this.reqmapping.put(_pgmapinfos.requrl, _pgmapinfos);
                    if (curclass.isAnnotationPresent(Apidoc.class)) {
                        Apidoc doc = curclass.getAnnotation(Apidoc.class);
                        if (doc.Module() != null && doc.Module().length() > 0) {
                            classModule = doc.Module();
                        }
                        if (doc.Cates() != null && doc.Cates().length() > 0) {
                            classCates = doc.Cates();
                        }
                    }
                    HashMap<String, Method> tmpdeclaredmethods = new HashMap<String, Method>();
                    for (Method mth : curclass.getDeclaredMethods()) {
                        APIPara tmppara;
                        boolean cancached = false;
                        if (mth.getReturnType().toString().toLowerCase().equals("void")) {
                            cancached = true;
                        }
                        if (mth.getName() == "OnPreInit") {
                            cancached = false;
                        }
                        String mthreqtype = "";
                        String methodrequrl = "";
                        if (cancached) {
                            tmpdeclaredmethods.put(mth.getName(), mth);
                            ReqMapInfo _mapinfos = new ReqMapInfo();
                            _mapinfos.reqclass = curclass;
                            _mapinfos.requrl = "/" + tmpclass + "/" + mth.getName() + HOYIConf.Suffix;
                            methodrequrl = tmpclass + "/" + mth.getName() + HOYIConf.Suffix;
                            _mapinfos.reqmethods = mth;
                            if (mth.isAnnotationPresent(RequestMethod.class)) {
                                RequestMode anos = mth.getAnnotation(RequestMode.class);
                                _mapinfos.requestTypes = anos.MODE();
                                mthreqtype = anos.MODE().toString();
                            }
                            this.reqmapping.put(_mapinfos.requrl, _mapinfos);
                        }
                        if (curclass.isAnnotationPresent(UnApiDoc.class) || !mth.isAnnotationPresent(Apidoc.class)) continue;
                        Apidoc methoddoc = mth.getAnnotation(Apidoc.class);
                        if (methoddoc.Module() != null && methoddoc.Module().length() > 0) {
                            classModule = methoddoc.Module();
                        }
                        if (methoddoc.Cates() != null && methoddoc.Cates().length() > 0) {
                            classCates = methoddoc.Cates();
                        }
                        APIEnti enti = new APIEnti(classModule, classCates, methoddoc.Notes(), methodrequrl, mthreqtype);
                        enti.retValue = mth.getReturnType().toString();
                        enti.CanReq = cancached;
                        for (ApiPara _pp : methoddoc.paras()) {
                            tmppara = new APIPara(_pp.Comment(), _pp.Name(), _pp.CHARType(), _pp.Notes(), _pp.Required());
                            enti.AddPara(tmppara);
                        }
                        for (ApiPara _px : methoddoc.response()) {
                            APIPara tmpresponse = new APIPara(_px.Comment(), _px.Name(), _px.CHARType(), _px.Notes(), _px.Required());
                            enti.AddResponse(tmpresponse);
                        }
                        for (ApiEntityPara entipa : methoddoc.entityparas()) {
                            if (entipa.Entity() == null || entipa.Entity().toString().length() <= 0) continue;
                            Entity tempEntity = (Entity)entipa.Entity().newInstance();
                            JSONObject arr = JSONObject.fromObject((Object)tempEntity, (JsonConfig)JsonLibCtrls.getjsonConfig());
                            Iterator skeyiter = arr.keys();
                            while (skeyiter.hasNext()) {
                                String skey = skeyiter.next().toString();
                                Field field = entipa.Entity().getDeclaredField("_" + skey);
                                if (field != null) {
                                    if (field.isAnnotationPresent(DbAttrANNO.class)) {
                                        DbAttrANNO tempdbattr = field.getAnnotation(DbAttrANNO.class);
                                        tmppara = new APIPara(tempdbattr.Comment() + "." + tempEntity.get_tableName(), tempdbattr.FieldName(), tempdbattr.type().toString(), tempdbattr.FieldName(), false);
                                        enti.AddPara(tmppara);
                                        continue;
                                    }
                                    tmppara = new APIPara(tempEntity.get_tableName() + ".", skey, "String", skey, false);
                                    enti.AddPara(tmppara);
                                    continue;
                                }
                                tmppara = new APIPara(tempEntity.get_tableName() + ".", skey, "String", skey, false);
                                enti.AddPara(tmppara);
                            }
                        }
                        APICons.getInstance().AddAPI(classModule, classCates, enti);
                    }
                    for (String _keys : this.reqmapping.keySet()) {
                        if (!DispatchConfig.ConsoleMapping) continue;
                        Console.Info((String)("mapping:" + _keys));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Console.Info((String)("Cache Page Finished, MAPPING.SIZE:" + this.reqmapping.size()));
    }

    public ReqMapInfo GetMapByURI(String _uri) {
        return this.reqmapping.get(_uri);
    }

    public Map<String, ReqMapInfo> GetMaps() {
        return this.reqmapping;
    }
}

