/*
 * Decompiled with CFR 0.152.
 */
package org.hoyi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;

public class CustomClassLoader
extends ClassLoader {
    public static String basedir;
    private HashSet className;

    public CustomClassLoader(String basedir, String[] clazns) throws Exception {
        super(null);
        CustomClassLoader.basedir = basedir;
        this.className = new HashSet();
        this.loadClassByMe(clazns);
    }

    private void loadClassByMe(String[] clazns) throws Exception {
        for (int i = 0; i < clazns.length; ++i) {
            this.loadDirectly(clazns[i]);
            this.className.add(clazns[i]);
        }
    }

    private Class loadDirectly(String name) throws Exception, Exception {
        Class cls = null;
        StringBuffer sb = new StringBuffer(basedir);
        String classname = name.replace('.', File.separatorChar) + ".class";
        sb.append(File.separator + classname);
        System.out.println(sb.toString());
        File classF = new File(sb.toString());
        cls = this.instantiateClass(name, new FileInputStream(classF), classF.length());
        return cls;
    }

    private Class instantiateClass(String name, InputStream fin, long len) throws Exception {
        byte[] raw = new byte[(int)len];
        fin.read(raw);
        fin.close();
        return this.defineClass(name, raw, 0, raw.length);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = null;
        cls = this.findLoadedClass(name);
        if (!this.className.contains(name) && cls == null) {
            cls = CustomClassLoader.getSystemClassLoader().loadClass(name);
        }
        if (cls == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(cls);
        }
        return cls;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    CustomClassLoader customClassLoader = new CustomClassLoader(CustomClassLoader.class.getResource("").getFile(), new String[]{"Foo"});
                    Class<?> cls = customClassLoader.loadClass("Foo");
                    Object foo = cls.newInstance();
                    Method m = foo.getClass().getMethod("sayHi", new Class[0]);
                    m.invoke(foo, new Object[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, 0L, 1000L);
    }
}

