/*
 * Decompiled with CFR 0.152.
 */
package org.hoyi.util;

import java.util.HashSet;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.PropertyFilter;
import org.hoyi.DB.Interface.baseExpert;
import org.hoyi.DB.model.DataColumn;
import org.hoyi.DB.model.DataRow;
import org.hoyi.DB.model.DataTable;

public class JsonUtil {
    public static JsonConfig Config = JsonUtil.createCfg();

    public static JsonConfig createCfg() {
        JsonConfig config = new JsonConfig();
        config.setJsonPropertyFilter(new PropertyFilter(){
            HashSet<String> set = new HashSet();
            {
                this.set.add("database");
                this.set.add("autoCommit");
                this.set.add("_isPersisted");
                this.set.add("_tableName");
                this.set.add("_entityComment");
                this.set.add("firstfield");
                this.set.add("secondfield");
                this.set.add("columns");
                this.set.add("count");
                this.set.add("tableName");
            }

            public boolean apply(Object source, String name, Object val) {
                if (source instanceof baseExpert || source instanceof DataTable) {
                    return this.set.contains(name);
                }
                return false;
            }
        });
        config.registerJsonValueProcessor(DataTable.class, new JsonValueProcessor(){

            public Object processObjectValue(String key, Object val, JsonConfig cfg) {
                if (val instanceof DataTable) {
                    DataTable dt = (DataTable)val;
                    JSONArray array = new JSONArray();
                    for (int i = 0; i < dt.getRows().size(); ++i) {
                        DataRow row = (DataRow)dt.getRows().get(i);
                        List columns = row.getColumns();
                        JSONObject json = new JSONObject();
                        for (int j = 0; j < columns.size(); ++j) {
                            if (row.GetData(j) instanceof String) {
                                String data = row.GetData(j) == null ? "" : row.GetData(j).toString();
                                json.element(((DataColumn)columns.get((int)j)).ColumnName, (Object)data);
                                continue;
                            }
                            json.element(((DataColumn)columns.get((int)j)).ColumnName, row.GetData(j), cfg);
                        }
                        array.add((Object)json);
                    }
                    return array;
                }
                return val;
            }

            public Object processArrayValue(Object val, JsonConfig cfg) {
                return null;
            }
        });
        config.registerJsonValueProcessor(DataRow.class, new JsonValueProcessor(){

            public Object processObjectValue(String key, Object val, JsonConfig cfg) {
                if (val instanceof DataRow) {
                    DataRow row = (DataRow)val;
                    List columns = row.getColumns();
                    JSONObject json = new JSONObject();
                    for (int j = 0; j < columns.size(); ++j) {
                        if (row.GetData(j) instanceof String) {
                            String data = row.GetData(j) == null ? "" : row.GetData(j).toString();
                            json.element(((DataColumn)columns.get((int)j)).ColumnName, (Object)data);
                            continue;
                        }
                        json.element(((DataColumn)columns.get((int)j)).ColumnName, row.GetData(j), cfg);
                    }
                    return json;
                }
                return val;
            }

            public Object processArrayValue(Object arg0, JsonConfig arg1) {
                return null;
            }
        });
        return config;
    }
}

