/*
 * Decompiled with CFR 0.152.
 */
package org.hoyi.wbsocket;

import java.io.IOException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import net.sf.json.JSONObject;
import org.hoyi.DB.ctrl.Console;
import org.hoyi.util.WebSocketMapUtil;

@ServerEndpoint(value="/hello")
public class MyWebSocketServer {
    private Session session;

    @OnOpen
    public void onOpen(Session session) {
        this.session = session;
        Console.Info((String)("onOpen" + session.getId()));
        WebSocketMapUtil.put(session.getId(), this);
    }

    @OnClose
    public void onClose() {
        WebSocketMapUtil.remove(this.session.getId());
        Console.Info((String)("====== onClose:" + this.session.getId() + " ======"));
    }

    @OnMessage
    public void onMessage(String params, Session session) throws Exception {
        MyWebSocketServer myWebSocket = WebSocketMapUtil.get(session.getId());
        Console.Info((String)("\u6536\u5230\u6765\u81ea" + session.getId() + "\u7684\u6d88\u606f" + params));
        String result = "\u6536\u5230\u6765\u81ea" + session.getId() + "\u7684\u6d88\u606f" + params;
        myWebSocket.sendMessage(1, "\u6210\u529f\uff01", result);
    }

    @OnError
    public void onError(Session session, Throwable error) {
        Console.Info((String)(session.getId() + "\u8fde\u63a5\u53d1\u751f\u9519\u8bef" + error.getMessage()));
        error.printStackTrace();
    }

    public void sendMessage(int status, String message, Object datas) throws IOException {
        JSONObject result = new JSONObject();
        result.put((Object)"status", (Object)status);
        result.put((Object)"message", (Object)message);
        result.put((Object)"datas", datas);
        this.session.getBasicRemote().sendText(result.toString());
    }
}

