package org.hoyi.dishop;

import java.io.IOException;

import org.hoyi.DB.ctrl.Console;
import org.hoyi.microservice.HoyiCloudApplication;
import org.hoyi.util.StreamUtils;

/**
 * 纯前端页面.
 * PureForeProject = true的话，不需要创建HoyiPage亦可以单独做前端了.
 * @author sam
 *
 */
public class PureForePage extends Hoyipage {

	@Override
	public void LoadHoyiHTML() throws IOException {
		//Console.Info("OnPageLoad()");
		if(this.htmlpath.toLowerCase().endsWith(".html")) {
			this.htmlpath = this.htmlpath.substring(0, this.htmlpath.length() - ".html".length());
		}
		
		if(themehtmls != null && themehtmls.length() > 0){
			int lastindex = this.htmlpath.lastIndexOf("/");
			if(lastindex > 0){
				htmlpath = htmlpath.substring(0, lastindex + 1);	
				htmlpath += themehtmls;	
			}else{
				htmlpath = themehtmls;	
			}
		}
		this.htmlpath += htmlostype;
		
		this.htmlpath = "WebRoot" + htmlpath + ".hoyip.html";
		Console.Info("htmlPath:" + htmlpath);
		// Windows 请用这个.
		// this.htmlpath = (getRequest().getRealPath("/") + "\\WEB-INF\\classes" + this.htmlpath);
		// 适应Linux修改
		// this.htmlpath = (getRequest().getRealPath("/") +File.separator +"WEB-INF" +File.separator +"classes" + this.htmlpath);

		// 页面缓存，这里可以加个开关，判断是否需要加页面缓存。
		if(OpenCacheHTML && htmlcache.keySet().contains(this.htmlpath)) {
			this.HtmlContent = htmlcache.get(this.htmlpath);
		}else {
			String contents;
			try {
				byte[] bytes = StreamUtils.Create().ReaderResource(HoyiCloudApplication.debugWebRootPath + this.htmlpath, htmlpath);
				ContainFile = true;
				contents = new String(bytes, "UTF-8");
			} catch (Exception e) {
				ContainFile = false;
				WriteUTF8Text("Can not find hoyi page html file." + this.htmlpath);
				Console.Error(e);
				return;
			}
			
			this.HtmlContent = contents.toString();
			
			if(HoyiCloudApplication.AutoRefreshPage) {
				if (!getParams("hoyiautofresh").equals("disabled")) {
					this.HtmlContent = this.HtmlContent.replaceFirst(
							"<head>", 
							"<head><meta http-equiv=\"refresh\" content=\"" +HoyiCloudApplication.AutoRefreshSeconds + "\">");
				}
			}
			htmlcache.put(this.htmlpath, this.HtmlContent);
		}

		getResponse().setContentType("text/html");
		getResponse().setCharacterEncoding("utf-8");

		//Console.Info("hoyipage url:" + this.htmlpath);
	}
}
