package org.hoyi.dispatchfact;

import java.lang.reflect.Constructor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.hoyi.DB.conf.HOYIConf;
import org.hoyi.DB.ctrl.Console;
import org.hoyi.dishop.Hoyipage;
import org.hoyi.dispatchs.responseUtil;
import org.hoyi.disptachs.model.JsonModel;
import org.hoyi.util.CustomClassLoader;
import org.hoyi.wb.comment.RequestType;

public class HoyiPageDispatcher implements IDispatcher{
	
	/**
	 * 是否启动热加载，热加载再部署环境中需要关闭.
	 * 调试环境中可以打开.
	 */
	public static boolean HotLoadClass = false;

	@Override
	public boolean doSth(HttpServletRequest _request, HttpServletResponse _response, String _requrl, RequestType _reqType) {
		if (_requrl.toLowerCase().endsWith(HOYIConf.Suffix)) {
			_requrl = _requrl.replace(HOYIConf.Suffix, ".class");

			if (_requrl.startsWith("/")) {
				_requrl = _requrl.substring(1);
			}
			if (_requrl.contains("/")) {
				_requrl = _requrl.replace("/", ".");
			}
			if (_requrl.contains("\\")) {
				_requrl = _requrl.replace("\\", ".");
			}
			_requrl = _requrl.replace(".class", "");
		}else{
			return false;
		}

		Console.Info("_requrl:" + _requrl);
		Class disp = null;
		String reqclass = "WebRoot." + _requrl;
		try {
			//热加载?
//			if(HotLoadClass) {
//				CustomClassLoader customClassLoader = new CustomClassLoader(
//						CustomClassLoader.class.getResource(reqclass).getFile(), null);
//				disp = customClassLoader.loadClass(reqclass);
//			}else {
				disp = Thread.currentThread().getContextClassLoader().loadClass(reqclass);
//			}
			
			
			Constructor[] cons = disp.getConstructors();
			Hoyipage page = (Hoyipage) cons[0].newInstance(new Object[0]);

			// 这里读取到后，判断page能访问的类型是否包含在当前访问类型内.
			page.currentReqType = _reqType;
			page.InitAndLoadRequestType();
			// 如果验证能通过.
			if (page.ValidateReq()) {
				_request.setCharacterEncoding("UTF-8");
				page.setRequest(_request);
				page.setResponse(_response);
				page.OnPreInit();

				if (!page.Behaviored)
					;
			} else {
				JsonModel model = new JsonModel(-998, "Request Type is not allow.requesturl:" + _requrl);
				// JsonModel model = new JsonModel(-998, "Request Type is not allow." + file.getAbsolutePath() + ",requesturl:" + requrl);
				responseUtil.getinstance().WriteUTF8JSON(_response, model);
			}
			return true;
		} catch (Exception e) {
			Console.Error(e);
			return false;
		}
	}

	

//	public boolean LoadHoyiPage(String reqclass, String requrl, HttpServletRequest request, HttpServletResponse response, RequestType _reqType) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
//		Class disp = null;
//		try {
//			disp = Thread.currentThread().getContextClassLoader().loadClass(reqclass);
//		} catch (Exception e) {
//			Console.Error(e);
//			Console.Info("ReadFileError:Can not find hoyip :" + requrl);
//			JsonModel model = new JsonModel(-996, "Load Hoyi Page Error,requesturl:" + requrl);
//			responseUtil.getinstance().WriteUTF8JSON(response, model);
//			return false;
//		}
//
//		Constructor[] cons = disp.getConstructors();
//		Hoyipage page = (Hoyipage) cons[0].newInstance(new Object[0]);
//
//		// 这里读取到后，判断page能访问的类型是否包含在当前访问类型内.
//		page.currentReqType = _reqType;
//		page.InitAndLoadRequestType();
//		// 如果验证能通过.
//		if (page.ValidateReq()) {
//			page.setRequest(request);
//			page.setResponse(response);
//			page.OnPreInit();
//
//			if (!page.Behaviored)
//				;
//		} else {
//			JsonModel model = new JsonModel(-998, "Request Type is not allow.requesturl:" + requrl);
//			// JsonModel model = new JsonModel(-998,
//			// "Request Type is not allow." + file.getAbsolutePath() +
//			// ",requesturl:" + requrl);
//			responseUtil.getinstance().WriteUTF8JSON(response, model);
//		}
//		return true;
//	}
	
	
}
