package org.hoyi.dishop;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.hoyi.DB.comment.DbAttrANNO;
import org.hoyi.DB.conf.HOYIConf;
import org.hoyi.DB.ctrl.Console;
import org.hoyi.DB.ents.Entity;
import org.hoyi.WebRender.HoyiJSConfig;
import org.hoyi.microservice.HoyiCloudApplication;
import org.hoyi.util.CutStrInfo;
import org.hoyi.util.DomainUtil;
import org.hoyi.util.HTMLUtils;
import org.hoyi.util.HttpRequestDeviceUtils;
import org.hoyi.util.MethodCutInfo;
import org.hoyi.util.StreamUtils;
import org.hoyi.wb.comment.PostParam;
import org.hoyi.web.ctrls.IHoyiCtrl;
import org.hoyi.web.ctrls.Module;
import org.hoyi.web.ctrls.Repeater;
import org.hoyi.web.events.IExcuteKeyListener;


/**
 * Author:ellen Email:ellen@kuaifish.com CreateDate:2015-05-20
 * ModifyDate:2015-06-20 hoyi entities @ hoyi.org 使用请在项目关于内标注hoyi版权，
 * hoyi版权归hoyi.org所有
 */
public class Hoyipage  extends IHoyiCtrl {
	
	/**
	 * 页面HTML的缓存.
	 */
	protected static Map<String, String> htmlcache = new HashMap<>();
	
	public Hoyipage pageroot = this;
	public String htmlpath;
	protected Boolean ContainFile = Boolean.valueOf(false);
	/**
	 * 是否打开页面缓存.
	 * 关闭后会随时获取.
	 */
	public static boolean OpenCacheHTML = true;
	
	public Hoyipage parent;
	
	public Hoyipage(){}
	
	public Hoyipage(String id, Hoyipage _parent){
		this.parent = _parent;
		this.setId(id);
		// 是否为用户控件。
		this.CTRL_ATTR = true;
		_parent.PageChild.put(id, this);
	}
	/**
	 * 是否包含HOYIJS，如果包含的话，系统会自动将HOYIPOSJS输出到页面上，而不需要引用，
	 * 当前配置默认是关闭的，需要使用的时候可以打开
	 * 注意：HOYI POST JS依赖JQUERY，如果想要使用直接提交方法，请引入JQUERY。
	 */
	private boolean ContainHoyiJS = false;
	
	/**
	 * 是否包含JQUERY，因为HOYI POST依赖于JQUERY，所以如果开启了当前功能
	 * 则页面自动引入公网的JQUERY地址，也可以自己设置JQUERY地址.
	 */
	private boolean ContainJQuery = false;
	/**
	 * JQUERY版本，跟ContainJQUERY配置使用。
	 */
	private String JqueryVersion = "";
	/**
	 * JQUERYURL,如果设置了当前值，则ContainJQUERY和JQUERYVERSION失效.
	 */
	private String JqueryURL = "";
	
	/**
	 * 判断手机提交的请求。
	 * @return value
	 */
	public boolean isMobileRequest(){
		return HttpRequestDeviceUtils.isMobileDevice(getRequest());
	}
	
	/**
	 * hoyip.html文件读外部html
	 * @param url
	 * @return value
	 */
	public String WRITEHTML(String url){
//		return HTMLUtils.instance().WRITEHTML(getRequest(), url, this);
		return HTMLUtils.instance().WRITEHTMLResourceAsStream(getRequest(), url);
	}
	
	/**
	 * 替换特殊符号
	 * @param data
	 * @return value
	 */
	public String EJS(String data){
		if(data != null && data.length() > 0){
//			data = data.replace("&", "\\&").replace("'", "\\'").replace(" ", "\\ ").replace("<", "\\<").replace(">", "\\>").replace("\"", "\\\"");
			data = data.replace("&", "&amp;").replace("'", "\\'").replace(" ", "&nbsp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("%", "&#37;");
			return data;
		}
		return "";
	}
	
	/**
	 * 用户控件.
	 */
	public Map<String, Hoyipage> PageChild = new HashMap<>();
	
	/**
	 * 是否控件属性，若为控件属性，则不使用response.write输出.
	 */
	public boolean CTRL_ATTR = false;

	public String HtmlContent = "";

	protected boolean IsPostBack() {
		if (getParams("ispostback") == null) {
			return true;
		}
		return Boolean.parseBoolean(getParams("ispostback"));
	}
	
	public String GetValueById(String idString){
		return idString;
	}
	
	HashMap<String, HashMap<String, String>>  clickParas = new HashMap<>();
	
	public void PutClickPara(String eventid, String paramname, String paraelmid){
		if(clickParas.containsKey(eventid)){
			HashMap<String, String> pems = clickParas.get(eventid);
			pems.put(paramname, paraelmid);
			clickParas.put(eventid, pems);
		}else{
			HashMap<String, String> pems = new HashMap<>();
			pems.put(paramname, paraelmid);
			clickParas.put(eventid, pems);
		}
		
	}
	
	/**
	 * 获取定义在方法头的请求参数并生成JS.
	 * @return value
	 */
	public String GetPostPInMethod(){
//		return "var HOYIPOST_EVENTPAMS = [{ 'eventid': 'JJ', 'params': [ 'time','aa'] }];";
		
		String HOYIPOST_EVENTPAMS = "";
		
		Method[] methods = this.getClass().getDeclaredMethods();
		String[] ppms = null;
		PostParam[] _pParam = null;
		Class<?> cc = null;
		for (Method method : methods) {
			if(method.isAnnotationPresent(PostParam.class)){
				// 说明定义了参数说明.
				HOYIPOST_EVENTPAMS = HOYIPOST_EVENTPAMS + "{'eventid': '" + method.getName() + "','params': [";

				_pParam = (PostParam[]) method.getAnnotationsByType(PostParam.class);
				for (PostParam postParam : _pParam) {
					ppms = postParam.PARMS();
					for (String ss : ppms) {
						HOYIPOST_EVENTPAMS = HOYIPOST_EVENTPAMS + "'" + ss +"',";
					}
					cc = postParam.ENTITY();
					try{
						
						if (cc.newInstance() instanceof Entity) {
							Field[] fields = cc.getDeclaredFields();
							for (Field field : fields) {
								// 如果不是 DbAttrAnno，则添加到参数.
								if (!field.isAnnotationPresent(DbAttrANNO.class)) {
									HOYIPOST_EVENTPAMS = HOYIPOST_EVENTPAMS + "'" + field.getName() +"',";	
								}
							}
						}	
					}catch(Exception ex){
						
					}
				}
				if(HOYIPOST_EVENTPAMS.endsWith(",")){
					HOYIPOST_EVENTPAMS = HOYIPOST_EVENTPAMS.substring(0, HOYIPOST_EVENTPAMS.length() - 1);
				}

				HOYIPOST_EVENTPAMS =  HOYIPOST_EVENTPAMS + "]},";
			}

		}
		if(HOYIPOST_EVENTPAMS.endsWith(",")){
			HOYIPOST_EVENTPAMS = HOYIPOST_EVENTPAMS.substring(0, HOYIPOST_EVENTPAMS.length() - 1);
		}
		
		
		
		// 加密JSON.
		HOYIPOST_EVENTPAMS =  HOYIPOST_EVENTPAMS ;
		
		HOYIPOST_EVENTPAMS = "<script type=\"text/javascript\"> "
				+ "var HOYIPOST_EVENTPAMS = ["  +  HOYIPOST_EVENTPAMS +  "]; "
				+ "var HoyipRd= '" + HOYIConf.HRSA_Modules+";"+HOYIConf.HRSA_Exponent + "';"  // 公钥模跟指数.
						+ "</script>";
		
		return HOYIPOST_EVENTPAMS;
	}
	
	/**
	 * 获取在PreLoad定义的方法.
	 * @return value
	 */
	public String GetInitPara() {
		
//		return "var HOYICLICK_EVENTID = [			"+
//               "{										"+
//               "     'eventid': 'JSTT',						"+
//               "     'params': { 'times': '#txtext' }				"+
//               " }			"+
//               "];";
		
		String ccpp = "<script type=\"text/javascript\">"
				+ "var HOYICLICK_EVENTID = [";
		
		
		Iterator iter = clickParas.entrySet().iterator();
		while (iter.hasNext()) {
			Map.Entry entry = (Map.Entry) iter.next();
			
			HashMap<String, String> values = (HashMap<String, String>) entry.getValue();
			ccpp = ccpp + "{     'eventid': '" + entry.getKey()  + "','params':{";

			Iterator valueiter = values.entrySet().iterator();
			while (valueiter.hasNext()) {
				Map.Entry valueentry = (Map.Entry) valueiter.next();
				ccpp = ccpp + "     '" + valueentry.getKey() +"': '" + valueentry.getValue() +"' ,";
			}
			if(ccpp.endsWith(",")){
				ccpp = ccpp.substring(0, ccpp.length() - 1);
			}
			ccpp = ccpp + "}  }";
		}
		ccpp = ccpp + "];";
		ccpp = ccpp + "</script>";
		
//		System.out.println("CCPP:" + ccpp);
		return ccpp;
	}
	
	public String GetRootURL()
	{
		return DomainUtil.GetRootURL(parent.getClass());
	}
	
	@Override
	public boolean ExeBehavior() {
		// TODO Auto-generated method stub
		boolean superex = super.ExeBehavior();
		if (superex) {
			return superex;
		}

		boolean tempex=false;

		Hoyipage tmppage;
		for (String _id : this.PageChild.keySet()) {
			tmppage = this.PageChild.get(_id);
			tmppage.CTRL_ATTR = true;
			tmppage.setRequest(this.getRequest());
			tmppage.setResponse(this.getResponse());
			tmppage.currentReqType = this.currentReqType;

			tmppage.exinstance = tmppage;
			
			tmppage.InitContentByTemplates(this.HtmlContent);
			tempex = tmppage.ExeBehavior();
			 
			//if (tempex) {
				return true;
			//}
		}

		return false;
	}

	public boolean _containmds = false; 
	
	public String ExSimpleMDS(String _template){
		Method[] methods = new Method[]{};
		
		
		while ((_template.contains("<%#")) && (_template.contains("%>"))) {
			CutStrInfo cuts = new CutStrInfo("<%#", "%>", _template);
			Console.Info("Contain Method:" + cuts.EXPREDContent);

			boolean containmethod = cuts.Calc(false);
			String tmp = "<%#" + cuts.EXPREDContent + "%>";

			if (containmethod) {
				MethodCutInfo minfo = new MethodCutInfo();
				minfo.Calc(cuts.EXPREDContent);
				// 如果是静态属性或方法，则加入静态属性或方法执行
//				if(minfo.methodName.startsWith(cuts.EXPREDContent))
					

				Console.Info("MethodName:" + minfo.methodName);
				for (int i = 0; i < minfo.params.length; i++) {
					Console.Info("Params:" + minfo.params[i]);
				}
				for (int i = 0; i <4; i ++){
					switch (i) {
						case 0:
							methods = Hoyipage.this.exinstance.getClass().getDeclaredMethods();
							break;
						case 1:
							methods = Hoyipage.this.exinstance.getClass().getSuperclass().getDeclaredMethods();
							break;
						case 2:
							methods = Hoyipage.this.exinstance.getClass().getSuperclass().getSuperclass().getDeclaredMethods();
							break;
						case 3:
							methods = Hoyipage.this.exinstance.getClass().getSuperclass().getSuperclass().getSuperclass().getDeclaredMethods();
							break;
					}
					for (Method mds : methods) {
						if (mds.getName().equals(minfo.methodName)) {
							// System.out.println("MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM:"
							// + mds.getName());
							try {
								Object mstrs;
								// Object mstrs;
								if (mds.getParameterCount() > 0)
									mstrs = mds.invoke(Hoyipage.this.exinstance, minfo.params);
								else {
									mstrs = mds.invoke(Hoyipage.this.exinstance, new Object[0]);
								}
								_containmds = true;
								if (mstrs != null){
									//Console.Info("mstrs:" + mstrs);
								}
								else {
									Console.Info("mstrs is null");
								}
								if (_template.contains(tmp)) {
									_template = _template.replace(tmp, mstrs.toString());
								} else {
									_template = _template.replace(tmp, "<p>X_Can Not Find METHOD: " + cuts.EXPREDContent + "</p>");
									Console.Info("No Contained.");
									_containmds = false;
								}
							} catch(IllegalAccessException | IllegalArgumentException | InvocationTargetException e){
								Console.Error("any error here:" + e.getMessage());
							}
						}
					}
				}
				
				_template = _template.replace(tmp, "<p>Y_Can Not Find METHOD: " + cuts.EXPREDContent + "</p>");
			} else {
				tmp = "<%#" + cuts.EXPREDContent + "%>";
				Console.Error("<p>Can Not Find METHOD: " + cuts.EXPREDContent + "</p>");
				_template = _template.replace(tmp, "<p>Can Not Find METHOD: " + cuts.EXPREDContent + "</p>");
				_containmds = false;
			}
		}
		return _template;
	}

	public void OnPreInit() throws IOException {
		Console.Info("OnPreInit");
		this.exinstance = this;

		IExcuteKeyListener ExListener = new IExcuteKeyListener() {
			public String Execute(String _template) {
				return ExSimpleMDS(_template);
			}
		};
		this.pageroot.ExecuteListener = ExListener;

		OnExBehavior();
	}

	public void OnExBehavior() throws IOException {
		ExeBehavior();
		if (this.Behaviored) {
			return;
		}
		OnInit();
	}

	public void OnInit() throws IOException {
		OnPageLoad();
	}

	public void LoadHoyiHTML() throws IOException {
		//Console.Info("OnPageLoad()");
		this.htmlpath = getClass().toString();
		this.htmlpath = this.htmlpath.substring(6);
		this.htmlpath = this.htmlpath.replace(".", "/");
		
		if(themehtmls != null && themehtmls.length() > 0){
			int lastindex = this.htmlpath.lastIndexOf("/");
			if(lastindex > 0){
				htmlpath = htmlpath.substring(0, lastindex + 1);	
				htmlpath += themehtmls;	
			}else{
				htmlpath = themehtmls;	
			}
		}
		this.htmlpath += htmlostype;
		
		this.htmlpath += ".hoyip.html";
		Console.Info("htmlPath:" + htmlpath);	
		// Windows 请用这个.
		// this.htmlpath = (getRequest().getRealPath("/") + "\\WEB-INF\\classes" + this.htmlpath);
		// 适应Linux修改
		// this.htmlpath = (getRequest().getRealPath("/") +File.separator +"WEB-INF" +File.separator +"classes" + this.htmlpath);

		// 页面缓存，这里可以加个开关，判断是否需要加页面缓存。
		if(OpenCacheHTML && htmlcache.keySet().contains(this.htmlpath)) {
			this.HtmlContent = htmlcache.get(this.htmlpath);
		}else {
			String contents;
			
			try {
				byte[] bts = StreamUtils.Create().ReaderResource(HoyiCloudApplication.debugWebRootPath + this.htmlpath, htmlpath);
				contents = new String(bts, "UTF-8");
				ContainFile = true;
			} catch (Exception e) {
				ContainFile = false;
				WriteUTF8Text("Can not find hoyi page html file." + this.htmlpath);
				Console.Error(e);
				return;
			}
			
			this.HtmlContent = contents.toString();
			if(HoyiCloudApplication.AutoRefreshPage) {
				if (!getParams("hoyiautofresh").equals("disabled")) {
					this.HtmlContent = this.HtmlContent.replaceFirst(
							"<head>", 
							"<head><meta http-equiv=\"refresh\" content=\"" +HoyiCloudApplication.AutoRefreshSeconds + "\">");
				}
			}
			htmlcache.put(this.htmlpath, this.HtmlContent);
		}

		getResponse().setContentType("text/html");
		getResponse().setCharacterEncoding("utf-8");

		//Console.Info("hoyipage url:" + this.htmlpath);
	}

	public void OnPageLoad() {
		try {
			LoadHoyiHTML();
			OnPageLoaded();
		} catch (Exception e) {
			Console.Error(e);
		}
	}

	public IHoyiCtrl LoadCtrl(String ctrlid) {
		return new Repeater(ctrlid);
	}

	public void OnPageLoaded() {
		//Console.Info("OnPageLoaded()");
		OnAuthenticate();
	}

	public void OnAuthenticate() {
		//Console.Info("OnAuthenticate()");
		OnValidate();
	}

	public void OnValidate() {
		//Console.Info("OnValidate()");
		OnRender();
	}

	public void OnRender() {
		//Console.Info("OnRender()");
		// 执行页面方法
		//this.HtmlContent = this.pageroot.TransEXCUTEMethod(this.HtmlContent);
		
		// Module对模版进行渲染,这里可以把能渲染的类弄个数组，需要自己渲染的话，就初始化一个静态类，然后循环渲染.
		this.HtmlContent = Module.RenderModule(this, HtmlContent);
		
		// Console.Error(this.pageroot.childrends.size());
		Repeater tmprep;
//		UserControl tmpuscontrol ;
		String tmpContent ;
		for (String id : this.pageroot.childrends.keySet()) {
			IHoyiCtrl ctrl = (IHoyiCtrl) this.pageroot.childrends.get(id);
			if ((ctrl instanceof Repeater)) {
				tmprep = (Repeater) this.pageroot.childrends.get(id);
				tmprep.InitContentByTemplates(this.HtmlContent);
				tmpContent = ctrl.Render();
				if (!StringUtils.isEmpty(tmprep.HtmlContent)) {
					this.HtmlContent = this.HtmlContent.replace(tmprep.HtmlContent, tmprep.rendedHTMLContent);
				}
			}
		}

		// 执行页面方法
		this.HtmlContent = this.pageroot.TransEXCUTEMethod(this.HtmlContent);
		OnWriteHTML();
	}
	/**
	 * 渲染子模版.
	 * @param childctrl  子控件
	 * @param _datacount 数据源长度.
	 * @return
	 */
	public String RenderChild(IHoyiCtrl childctrl, int _datacount) {
		
		IHoyiCtrl ctrl2 = GetById(childctrl.getId());
		ctrl2.ExecuteListener = this.pageroot.ExecuteListener;
		ctrl2.setPageIndex(getpgindex());
		ctrl2.setPageCount(childctrl.getPageCount());
		ctrl2.CalcPageCount(_datacount, childctrl.getPageSize());
		if (ctrl2 != null) {
			return ctrl2.getRendedHTMLContent();
		}
		return "";
	}
	/**
	 * 模版是否已经渲染了Module,在重复调用渲染的时候生效.
	 */
	public boolean modluerended = false;

	public IHoyiCtrl GetById(String ctrlid) {
		IHoyiCtrl ctrl = null;

		if (StringUtils.isEmpty(this.HtmlContent)) {
			try {
				LoadHoyiHTML();
			} catch (IOException e) {
				Console.Error(e);
				return null;
			}
		}
		
		if(!modluerended) {
			// 有Module的时候，需要先将Moduel Render出来，再做渲染.。
			this.HtmlContent = Module.RenderModule(this, HtmlContent);
			modluerended = true;
		}

		for (String id : this.pageroot.childrends.keySet()) {
			if (id.equals(ctrlid)) {
				ctrl = (IHoyiCtrl) this.pageroot.childrends.get(id);
				ctrl.ExecuteListener = this.pageroot.ExecuteListener;
				if ((ctrl != null) && ((ctrl instanceof Repeater))) {
					ctrl.InitContentByTemplates(this.HtmlContent);

					ctrl.Render();
				}
			}
		}

		return ctrl;
	}
	/**
	 * Jquery Libraries.
	 * @return value
	 */
	public String JqueryLib() {
		String hoyipostjs = "";
		if(getJqueryURL().trim().length() > 0) { // 如果本地设置了Jquery路径，则JqueryVersion等失效.
			hoyipostjs += "		<script typet=\"text/javascript\" src=\"" + getJqueryURL() + "\"></script>\n";
		}else {
			if(this.getJqueryVersion().trim().length() > 0) {
				String versionurl = "";
				versionurl = HoyiJSConfig.getInstance().GetJqueryByVarsion(this.getJqueryVersion());
				hoyipostjs += "		<script typet=\"text/javascript\" src=\"" + versionurl + "\"></script>\n";
			}else {
				hoyipostjs += "		<script typet=\"text/javascript\" src=\"" + HoyiJSConfig.getInstance().defJqueryURL + "\"></script>\n";
			}
		}
		return hoyipostjs;
	}
	
	/**
	 * Jquery ValiLib
	 * @return value
	 */
	public String JqueryValidatorLib() {
		return HoyiJSConfig.getInstance().GetJqueryValiLibs();
	}
	
	/**
	 * jquery,bootstrap,  cdn失效的话，改底层就OK了。
	 * @return value
	 */
	public String BootstrapLib(){
		return HoyiJSConfig.getInstance().GetBootStrapLibs();
	}
	/**
	 * hoyi-req.js
	 * hoyi-server-req.v.1.31.s
	 * @return value
	 */
	public String HoyiReqLib() {
		return HoyiJSConfig.getInstance().GetHoyiReqLib();
	}
	
	/**
	 * jquery.js
	 * hoyi-req.js
	 * hoyi-server-req.v.1.31.js
	 * @return value
	 */
	public String HoyReqWJquery() {
		return JqueryLib() + HoyiReqLib();
	}
	
	/**
	 * 默认hoyi page 提交,
	 * jquery + bootstrap + jqueryvalidator + hoyireq
	 * @return value
	 */
	public String DefHoyiPageLib() {
		return JqueryLib() + BootstrapLib() + JqueryValidatorLib() + HoyiReqLib();
	}
	/**
	 * 通用HoyiPage 需要的js,css文件引用。
	 * @return value
	 */
	public String HoyiLib() {
		return DefHoyiPageLib();
	}
	
	/**
	 * SB Admin
	 * @return value
	 */
	public String SBAdminLib() {
		return "		<link href=\"https://cdn.bootcss.com/startbootstrap-sb-admin-2/3.3.7+1/css/sb-admin-2.min.css\" rel=\"stylesheet\">\n"
				+"		<script src=\"https://cdn.bootcss.com/startbootstrap-sb-admin-2/3.3.7+1/js/sb-admin-2.min.js\"></script>\n";
	}
	
	/**
	 * 带jquery,hoyi,bootstrap, sbadmin
	 * @return value
	 */
	public String HoyiPageSBAdminLib() {
		return DefHoyiPageLib() + SBAdminLib();
	}
	
	/**
	 * 设置是否需要加载JQUERY和HOYI REQ,HOYI SERVER POST,
	 * 开启了之后，则不需要引用Jquery和HOYIPOST文件了。
	 * 注意不要重复引用。
	 * 设置的时候请重写OnPreInit()方法，并置于super.OnPreInit()之前.
	 */
	public String GetHoyiPostJS() {
		String hoyipostjs = "";
		
		if(isContainJQuery()) {
			hoyipostjs += JqueryLib();
		}
		if (isContainHoyiJS()) {
			hoyipostjs += HoyiReqLib();
		}
		
		return hoyipostjs;
	}

	private boolean iscontaininitpara = true;

	public void setContainInitPara(boolean containpara){
		iscontaininitpara = containpara;
	}

	public boolean IsContainInitPara(){
		return iscontaininitpara;
	}

	public void OnWriteHTML()
	{
		if (!CTRL_ATTR) {
			// 写参数方法和固有HTML.
			String retObjs = this.HtmlContent;
			if(this.IsContainInitPara()){
				retObjs += GetPostPInMethod() + GetInitPara();
			}
			if(this.isContainHoyiJS()) {
				retObjs +=  GetHoyiPostJS();
				//WriteUTF8HTML(this.HtmlContent + GetPostPInMethod() + GetInitPara() + GetHoyiPostJS());
			}
				//WriteUTF8HTML(this.HtmlContent + GetPostPInMethod() + GetInitPara() );
			WriteUTF8HTML(retObjs);
			// 不使用PUTEVENT方法，全部使用头的方法。
			//WriteUTF8HTML(this.HtmlContent + GetPostPInMethod());
			OnEnd();
		}
	}

	public boolean isContainHoyiJS() {
		return ContainHoyiJS;
	}

	public void setContainHoyiJS(boolean containHoyiJS) {
		ContainHoyiJS = containHoyiJS;
	}

	public boolean isContainJQuery() {
		return ContainJQuery;
	}

	public void setContainJQuery(boolean containJQuery) {
		ContainJQuery = containJQuery;
	}

	public String getJqueryVersion() {
		return JqueryVersion;
	}

	public void setJqueryVersion(String jqueryVersion) {
		JqueryVersion = jqueryVersion;
	}

	public String getJqueryURL() {
		return JqueryURL;
	}

	public void setJqueryURL(String jqueryURL) {
		JqueryURL = jqueryURL;
	}

	public void OnEnd() {
		Console.Info("OnEnd()");
	}
}
