package org.hoyi.mcache;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentSkipListSet;

import org.hoyi.DB.ctrl.Console;

/**
 * 方法缓存，将系统内所有的方法缓存起来。
 * 以便更方便的找到方法。
 * 
 * @author Ellen
 *
 */
public class MethodCache {

	/**
	 * 缓存的所有Service地址.
	 */
	private static ConcurrentSkipListSet<String>  services = new ConcurrentSkipListSet<>();
	
	
	
	public static synchronized int InitServicesMap() 
	{
		ClassLoader loader = Thread.currentThread().getContextClassLoader();
		
		Enumeration<URL> a;
		File directory = null;
		try {
			a = loader.getResources("WebRoot");
			String tmpurl = "";
			while (a.hasMoreElements()) {
				URL url = (URL) a.nextElement();
				Console.Info("url:" + url);
				
				tmpurl = url.getFile().substring(0, url.getFile().length() - 1);
				
				TransFolder(tmpurl);
			}
			
		} catch (IOException e) {
			Console.Error(e);
		}
		Console.Info("----------------------------------------------------------------------------------------");
		Console.Info("Service.Length:" + services.size());
		for (String string : services) {
			Console.Info(string);
		}
		Console.Info("----------------------------------------------------------------------------------------");
		return 1;
	}
	
	public static void TransFolder(String folderurl)
	{
		File file = new File(folderurl);
		
		String[] files = file.list();
		Console.Info("TRANSFOLDER:" + folderurl);
		if (files != null) {
			for (String string : files) {
				if (string.endsWith(".class")) // 以 class结束的说明是可用的 Service.
				{
					// 这里还可以将class和hoyip.html缓存起来.内存虽然增加了，但是访问效率也加速了。
					// 现在整个文件也是从内存中读取的，所以也不会慢。  不过文件的HOYI段等分析可以缓存起来，不用每次分析html文件，速度上就加快了。
					
					services.add(folderurl + "/" + string);
				}else {
					TransFolder(folderurl + "/" +  string);
				}
			}
		}

	}
}
