package org.hoyi.microservice;

import java.util.HashMap;
import java.util.Map;

/**
 * 针对服务发现
 * @author sam
 *
 */
public class HoyiServiceConfig {
	
	/**
	 * 
	 * HOST,    domain or ip address
	 * PORT,
	 * WEBCONTENT,  ./webcontent  是用web项目启动，其他配置都是Java 项目启动.
	 * NEED_PORT,  是否需要申请服务端分配端口。
	 * PORT-BAK  备用端口，用于服务复制和服务端分配端口用. 1963，1964，1965-1957
	 * 
	 */
	private Map<String, String> HOYI;
	
	/**
	 * DISPATCHER-URL   // 调度器路径
	 * 
	 * SERVICE-TYPE; // DISPATCHER, PROVIDER   服务调度器，服务供应器。  这个默认是服务提供器.因为调度器会有服务调度操作界面.
	 * SERVICE-ID;  // 服务ID，同一类的服务用同一个ID，例如：SERVICE-ORDER.
	 * SERVICE-UUID; // 唯一服务标识。调度器端提供。
	 * SERVICE-PARENT-ID; // 父服务ID， 用SERVICEUUID 来标识的.
	 * 
	 */
	private Map<String, String> SERVICE;
	
	/**
	 * SERVICE-COPY-DIRECT-SRC    // 复制服务的源文件夹路径
	 * SERVICE-COPY-DIRECT-TARGET // 复制服务的目标文件夹路径
	 * SERVICE-COPY-TYPE          // 服务器命名规则
	 * SERVICE-COPY-JAR           // 复制完成后启动服务的jar包路径
	 */
	private Map<String, String> SERVICECOPY;
	
	/**
	 * CPU
	 * DISK
	 * MEMO
	 */
	private Map<String, String> COMPUTERINFO; 
	
	/**
	 * Nginx 配置
	 * URL
	 * CONF-URL
	 * OSTYPE  MAC LINUX WINDOWS
	 * 
	 */
	private Map<String, String> NGINX; // naginx 配置，配置项目包括:

	public Map<String, String> getHOYI() {
		if(HOYI == null)
			HOYI = new HashMap<>();
		return HOYI;
	}

	public void setHOYI(Map<String, String> hOYI) {
		HOYI = hOYI;
	}

	public Map<String, String> getSERVICE() {
		if(SERVICE == null)
			SERVICE = new HashMap<>();
		return SERVICE;
	}

	public void setSERVICE(Map<String, String> sERVICE) {
		SERVICE = sERVICE;
	}

	public Map<String, String> getSERVICECOPY() {
		if(SERVICECOPY == null)
			SERVICECOPY = new HashMap<>();
		return SERVICECOPY;
	}

	public void setSERVICECOPY(Map<String, String> sERVICECOPY) {
		SERVICECOPY = sERVICECOPY;
	}

	public Map<String, String> getCOMPUTERINFO() {
		if(COMPUTERINFO == null)
			COMPUTERINFO = new HashMap<>();
		return COMPUTERINFO;
	}

	public void setCOMPUTERINFO(Map<String, String> cOMPUTERINFO) {
		COMPUTERINFO = cOMPUTERINFO;
	}

	public Map<String, String> getNGINX() {
		if(NGINX == null)
			NGINX = new HashMap<>();
		return NGINX;
	}

	public void setNGINX(Map<String, String> nGINX) {
		NGINX = nGINX;
	}
	
	  @Override
	    public String toString() {
	        return "HoyiServiceConfig{" +
	                "HOYI=" + HOYI +
	                ", SERVICE='" + SERVICE + '\'' +
	                ", SERVICECOPY=" + SERVICECOPY +
	                ", COMPUTERINFO=" + COMPUTERINFO +
	                ", NGINX=" + NGINX +
	                '}';
	    }
	
}
