package org.hoyi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.hoyi.DB.ctrl.Console;
import org.hoyi.microservice.HoyiCloudApplication;

public class HTMLUtils {

	private static HTMLUtils _instance;

	public static HTMLUtils instance() {
		if (_instance == null) {
			_instance = new HTMLUtils();
		}
		return _instance;
	}

	/**
	 * 是否打开HTML的Cache.
	 */
	public static boolean OpenHTMLCache = true;

	/**
	 * WRITEHTML的缓存.
	 */
	private static Map<String, String> writehtmlcache = new HashMap<>();

	public String WRITEHTMLResourceAsStream(HttpServletRequest request, String url) {

		String contents = "->UNKNOWN HTML TEMPS<-";
		if (url.startsWith("\"") && url.endsWith("\"")) {
			url = url.substring(1, url.length() - 1);
		}

		if (url.trim().length() > 0 && url.contains(".")) {
			Console.Info("_requrl:" + url);

			if (OpenHTMLCache && writehtmlcache.containsKey(url)) {
				contents = writehtmlcache.get(url);
			} else {

				String loadurl = "WebRoot" + url;
				String debugurl = HoyiCloudApplication.debugWebRootPath + "WebRoot" + url;

				contents = "";
				try {
					byte[] bytes = StreamUtils.Create().ReaderResource(debugurl, loadurl);
					contents = new String(bytes, "UTF-8");
				} catch (Exception e) {
					contents = "->HTML CONTENT READ ERROR<-";
				}
				
				writehtmlcache.put(url, contents);
			}
		}
		return contents;
	}
//  废弃.因在各种环境下读取有很严重的问题。so,弃用.
//	public String WRITEHTML(HttpServletRequest request, String url, Object targetpage) {
//		Console.Info("WRITEHTML:--------------------->");
//		boolean jarfilerun = false;
//		try {
//			String realPath = "";
//			if(HoyiCloudApplication.REQ_PORT == -1) {
//				Console.Info("WRITEHTML:--------------------->1");
//				// 无端口，默认为从TOMCAT启动。
//				// 这个是之前部署TOMCAT的获取路径用法，如果WRITEHTML失效，建议打开这个路径。
//				 realPath = request.getSession().getServletContext().getRealPath("/") + "WEB-INF/classes/WebRoot" + url;
//				 Console.Info("REQ_PORT: -1, realPath:" + realPath);
//			}else {
//				Console.Info("WRITEHTML:--------------------->2");
//				
//				String configPath = GetLoadHTMLPath(request, targetpage);
//
//				configPath = URLDecoder.decode(configPath, "utf-8");
//				Console.Info("decoded.configpath1:" + configPath);
//				
//				if (configPath.endsWith(".jar") || configPath.endsWith(".war")) { // jar 或者war 的时候，需要到jar包内读.
//					Console.Info("WRITEHTML:--------------------->3");
//					jarfilerun = true;
//					try {
//						JarFile localJarFile = new JarFile(new File(configPath));
//
//						Enumeration<JarEntry> entries = localJarFile.entries();
//						while (entries.hasMoreElements()) {
//							JarEntry jarEntry = entries.nextElement();
//							if (jarEntry.getName().endsWith(url)) {// &&
//								realPath = jarEntry.getName();
//								Console.Info("url------------------------->:" + jarEntry.getName());
//							}
//						}
//					} catch (Exception e) {
//						Console.Error(e);
//					}
//				}else {
//					Console.Info("WRITEHTML:--------------------->4");
//					realPath = configPath + "WebRoot" + url;
//				}
//			}
//
//			Console.Info("REALPTHL:" + realPath);
//
//			String html = "";
//			if (readedfilemap.keySet().contains(realPath)) {
//				 Console.Info("-------------------> contain ed file");
//				html = readedfilemap.get(realPath);
//			} else {
//				html = FileCtrl.instance().readFileByChars(realPath, "UTF-8", jarfilerun);
//				Console.Info("-------------------> not contain file");
//				readedfilemap.put(realPath, html);
//			}
//
//			return html;
//		} catch (Exception ex) {
//			return "未找到文件." + ex.getMessage();
//		}
//	}

//	public String GetLoadHTMLPath(HttpServletRequest request, Object targetpage) {
//		// 这里是HoyiCloudApplication启动的方法，请注意区分.
//		Console.Info("GetLoadHTMLPath--------------------->1");
//		// 这个方法打包后可用。
//		String configPath = HTMLUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
//		Console.Info("GetLoadHTMLPath--------------------->2");
////		if(targetpage != null) {
////			configPath =  targetpage.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
////		}
//
//		// 这个方法打包后不可用.
//		String configPath2 = getClass().getResource("/").getPath();
//		Console.Info("GetLoadHTMLPath--------------------->3");
//
//		String configPath3 = request.getSession().getServletContext().getRealPath("/") + "/";
//		Console.Info("GetLoadHTMLPath--------------------->4");
//
//		Console.Info("configpath1.protectionDomain():" + configPath);
//		Console.Info("configPath2.getClass():" + configPath2);
//		Console.Info("configPath3.getClass():" + configPath3);
//
//		String result = "";
//		if (configPath.toLowerCase().endsWith(".jar")) {
//			result = configPath;
//		} else {
//			if (configPath2.contains(configPath3)) {
//				result = configPath2;
//			} else {
//				result = configPath;
//			}
//		}
//
//		return result;
//	}
}
