package org.hoyi.disptachs.model;

import java.util.HashMap;
import java.util.Map;

public class fieldstr {
	/**
	 * 
	 * @param _chfield 中文名
	 * @param _engfield 英文名
	 */
	public fieldstr(String _chfield, String _engfield) {
		this.setChfield(_chfield);
		this.setEngfield(_engfield);
	}

	/**
	 *  
	 * @param _chfield 中文名
	 * @param _engfield 英文名
	 * @param tableshow 是否在Table内显示
	 * @param required 是否需要验证
	 */
	public fieldstr(String _chfield, String _engfield, boolean tableshow, boolean required) {
		this.setChfield(_chfield);
		this.setEngfield(_engfield);
		this.setUpdateneed(tableshow);
		this.setTableshow(tableshow);
		if(required) {
			valirole.put("required", "required");
			this.setValirole(valirole);
		}
	}
	/**
	 * 
	 * @param _chfield 中文名
	 * @param _engfield 英文名
	 * @param tableshow 是否在Table内显示
	 * @param required 是否需要验证
	 * @param hideel 是否隐藏当前列.
	 */
	public fieldstr(String _chfield, String _engfield, boolean tableshow, boolean required, boolean hideel) {
		this.setChfield(_chfield);
		this.setEngfield(_engfield);
		this.setHideel(hideel);
		this.setTableshow(tableshow);
		if(required) {
			valirole.put("required", "required");
			this.setValirole(valirole);
		}
	}
	
	/**
	 * 
	 * @param _chfield 中文名
	 * @param _engfield 英文名
	 * @param tableshow 是否在Table内显示
	 * @param required 是否需要验证
	 * @param hideel 是否隐藏当前列.
	 * @param makeel 是否生成当前列.不生成的话,则在代码中都不显示当前列.
	 */
	public fieldstr(String _chfield, String _engfield, boolean tableshow, boolean required, boolean hideel, boolean makeel) {
		this.setChfield(_chfield);
		this.setEngfield(_engfield);
		this.setHideel(hideel);
		this.setTableshow(tableshow);
		this.setMakeel(makeel);
		if(required) {
			valirole.put("required", "required");
			this.setValirole(valirole);
		}
	}
	
	/**
	 * 
	 * @param _chfield 中文名
	 * @param _engfield 英文名
	 * @param tableshow 是否在Table内显示
	 * @param required 是否需要验证
	 * @param hideel 是否隐藏当前列.
	 * @param makeel 是否生成当前列.不生成的话,则在代码中都不显示当前列.
	 * @param _updateneed 新增,修改的是否是否需要用到.
	 */
	public fieldstr(String _chfield, String _engfield, boolean tableshow, boolean required, boolean hideel, boolean makeel, boolean _updateneed) {
		this.setChfield(_chfield);
		this.setEngfield(_engfield);
		this.setHideel(hideel);
		this.setTableshow(tableshow);
		this.setMakeel(makeel);
		this.setUpdateneed(_updateneed);
		if(required) {
			valirole.put("required", "required");
			this.setValirole(valirole);
		}
	}
	
	
	private String chfield;
	
	private String engfield;
	
	/**
	 * hideel = true 则 display=none
	 */
	private boolean hideel = false;
	
	/**
	 * 是否在table里面显示.
	 */
	private boolean tableshow = true;
	
	/**
	 * 增删改查的是否是否生成对象.
	 */
	private boolean makeel = true;
	
	/**
	 * 新增,修改提交时候是否需要用到.
	 */
	private boolean updateneed = true;
	
	/**
	 * 验证规则,例如 require = 'required'
	 */
	private Map<String, String> valirole = new HashMap<>();

	public String getChfield() {
		return chfield;
	}

	public void setChfield(String chfield) {
		this.chfield = chfield;
	}

	public String getEngfield() {
		return engfield;
	}

	public void setEngfield(String engfield) {
		this.engfield = engfield;
	}

	public boolean isHideel() {
		return hideel;
	}

	public void setHideel(boolean hideel) {
		this.hideel = hideel;
	}

	public Map<String, String> getValirole() {
		return valirole;
	}

	public void setValirole(Map<String, String> valirole) {
		this.valirole = valirole;
	}
	
	public boolean Required() {
		return this.getValirole().containsKey("required");
	}

	public boolean isTableshow() {
		return tableshow;
	}

	public void setTableshow(boolean tableshow) {
		this.tableshow = tableshow;
	}

	public boolean isMakeel() {
		return makeel;
	}

	public void setMakeel(boolean makeel) {
		this.makeel = makeel;
	}

	public boolean isUpdateneed() {
		return updateneed;
	}

	public void setUpdateneed(boolean updateneed) {
		this.updateneed = updateneed;
	}
	
	
	
	
}
