package org.hoyi.dispatchfact;

import java.lang.reflect.Constructor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.hoyi.DB.ctrl.Console;
import org.hoyi.dishop.Hoyipage;
import org.hoyi.dispatchs.responseUtil;
import org.hoyi.disptachs.model.JsonModel;
import org.hoyi.staticcache.HoyiPageStaticCache;
import org.hoyi.staticcache.ReqMapInfo;
import org.hoyi.util.CustomClassLoader;
import org.hoyi.wb.comment.RequestType;

public class MappingDispatcher implements IDispatcher{

	@Override
	public boolean doSth(HttpServletRequest _request, HttpServletResponse _response, String _requrl, RequestType _reqType) {
		String requesturi =  _request.getRequestURI().replaceFirst(_request.getContextPath(), "");
		//Console.Info("requestURI:" + requesturi);
		
		ReqMapInfo mapinfos = HoyiPageStaticCache.getInstance().GetMapByURI(requesturi);
		if(mapinfos == null)
			return false;
		
		Class disp = null;
		if(HoyiPageDispatcher.HotLoadClass) {
			try {
				// 每次都创建出一个新的类加载器
				CustomClassLoader customClassLoader = new CustomClassLoader(CustomClassLoader.basedir, new String[] { });
				disp = customClassLoader.loadClass(mapinfos.reqclass.getName());
			} catch (Exception e) {
				Console.Error(e);
			}
		}else {
			disp = mapinfos.reqclass;
		}
		try {
			Constructor[] cons = disp.getConstructors();
			Hoyipage page = (Hoyipage) cons[0].newInstance(new Object[0]);
			page.reqmapinfo = mapinfos;

			// 这里读取到后，判断page能访问的类型是否包含在当前访问类型内.
			page.currentReqType = _reqType;
			page.InitAndLoadRequestType();
			// 如果验证能通过.
			if (page.ValidateReq()) {
				_request.setCharacterEncoding("UTF-8");
				page.setRequest(_request);
				page.setResponse(_response);
				page.OnPreInit();

				if (!page.Behaviored)
					;
			} else {
				JsonModel model = new JsonModel(-998, "Request Type is not allow.requesturl:" + _requrl);
				// JsonModel model = new JsonModel(-998, "Request Type is not allow." + file.getAbsolutePath() + ",requesturl:" + requrl);
				responseUtil.getinstance().WriteUTF8JSON(_response, model);
			}
			return true;
		} catch (Exception e) {
			Console.Error(e);
			return false;
		}
	}

	

//	public boolean LoadHoyiPage(String reqclass, String requrl, HttpServletRequest request, HttpServletResponse response, RequestType _reqType) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
//		Class disp = null;
//		try {
//			disp = Thread.currentThread().getContextClassLoader().loadClass(reqclass);
//		} catch (Exception e) {
//			Console.Error(e);
//			Console.Info("ReadFileError:Can not find hoyip :" + requrl);
//			JsonModel model = new JsonModel(-996, "Load Hoyi Page Error,requesturl:" + requrl);
//			responseUtil.getinstance().WriteUTF8JSON(response, model);
//			return false;
//		}
//
//		Constructor[] cons = disp.getConstructors();
//		Hoyipage page = (Hoyipage) cons[0].newInstance(new Object[0]);
//
//		// 这里读取到后，判断page能访问的类型是否包含在当前访问类型内.
//		page.currentReqType = _reqType;
//		page.InitAndLoadRequestType();
//		// 如果验证能通过.
//		if (page.ValidateReq()) {
//			page.setRequest(request);
//			page.setResponse(response);
//			page.OnPreInit();
//
//			if (!page.Behaviored)
//				;
//		} else {
//			JsonModel model = new JsonModel(-998, "Request Type is not allow.requesturl:" + requrl);
//			// JsonModel model = new JsonModel(-998,
//			// "Request Type is not allow." + file.getAbsolutePath() +
//			// ",requesturl:" + requrl);
//			responseUtil.getinstance().WriteUTF8JSON(response, model);
//		}
//		return true;
//	}
	
	
}
