package org.hoyi.microservice;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.Servlet;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.hoyi.DB.ctrl.Console;
import org.hoyi.DB.util.ConfigUtil;
import org.hoyi.dishop.Hoyipage;
import org.hoyi.dispatchfact.HoyiPageDispatcher;
import org.hoyi.dispatchs.DispatcherServlet;
import org.hoyi.sessionlisten.SessionIniter;
import org.hoyi.util.CustomClassLoader;
import org.hoyi.util.HTMLUtils;
import org.hoyi.util.HttpRequest;
import org.hoyi.util.StreamUtils;
import org.yaml.snakeyaml.Yaml;

import net.sf.json.JSONObject;

/**
 * 
 * 1. 负载均衡用nginx直接配置，断熔器可以由nginx处理. 2. 模式1，直接启动端口，发送服务ID给调度注册，
 * 模式2，直接发送服务ID给调度端，由调度端发送可用端口给服务端，并启动服务。 当未收到调度端的回复时，自动隔固定时间请求，可以以次数和时间来做请求限制。
 * 3. 当想重新启动服务时，可以由服务端发起复制服务端的请求，并启动当前服务端。 4. 就要求每台调度服务器需要一个nginx。
 * 
 * 关键流程
 * 
 * 1. 类型： serviceDispatcher Server, serviceProvider Server, nginx Server
 * 
 * 2. 启动1:
 * HoyiCloudApplication.Start("ServiceID", port)
 * HoyiCloudApplication.Start(port)
 * 
 * 3. 启动2: HoyiCloudApplication.ReqProvide("ServiceID") 由调度端分配Port.
 * HoyiCloudApplication.ReqProvide("ServiceID", "ParentServiceID")
 * 
 * 4. 增加服务： 调度端：后台界面->选择服务->选择扩充->自动增加了对应的几个服务上来。 本地端：得到复制命令->复制服务文件->启动服务
 * 【需要服务复制的考虑留一个备份，谨防执行中的文件复制失败。】
 * 
 * 5. 调度端：需要安装nginx并且配置好命令行执行,Web 服务端和调度端需要配置操作系统类型、nginx.conf路径，
 * 这个可以默认提供几个系统的路径，可以自己修改。 服务提供端需要配置：文件复制源地址，文件复制目标地址，文件夹名规则，服务启动命令。
 * 
 * 6. 调度关系: 
 * sdispacher->nginx->nginx->sprovider 
 * sdispacher->nginx->sprovider
 * sdispacher->nginx->sdispatcher->nginx->sprovider
 * 
 * 服务提供端总在最后一层。
 * 
 * 启动实例：
 * 
 * public class JettyServer { 
 * 	public static void main(String[] args) {
 * 		HoyiCloudApplication.Start(); //HoyiCloudApplication.Start(8081); 
 * 	} 
 * }
 * 
 * 
 * @param args
 */
public class HoyiCloudApplication {
	
	/**
	 * 是否通过HoyiCloudAPP启动的.
	 */
	public static boolean CloudAppStarting = false;

	/**
	 * 
	 * 因外部编辑器修改文件后，Eclipse不能立马响应并部署HTML文件，
	 * 遂在DEBUG模式下，将WEBROOT目录设置为源码目录，而不是编译后的目录，
	 * 这样可以在用外部文件修改编码后，直接从源码目录加载，
	 * 而不需要重启服务，甚至重新编译系统.
	 * 
	 */
	public static String debugWebRootPath = "";
	
	/**
	 * 打开开发模式，不做混存处理，
	 */
	public static boolean DevelopingMode = false;
	/**
	 * 在编写页面的时候，自动刷新页面
	 */
	public static boolean AutoRefreshPage = false;
	/**
	 * 自动刷新页面的秒数.
	 */
	public static int AutoRefreshSeconds = 3;


	/**
	 * 请求的端口.
	 */
	public static int REQ_PORT = -1;

	/**
	 * 是否需要调度端分配端口.
	 */
	public static String NEED_PORT;

	public static HoyiServiceConfig hoyiconfig;

	/**
	 * 服务器注册的可分配端口，请求端口的时候自动分配给本地， Map<IP, List<Port>> 为统一标准，localhost和127.0.0.1
	 * 统一转换为localhost
	 */
	private static Map<String, List<String>> PORT_BAKS = new HashMap<>();

	/**
	 * 已经使用了的端口列表. 自己提交，自己启动的服务会注册到已使用的端口列表内.
	 */
	private static Map<String, List<String>> PORT_USED = new HashMap<>();

	public static void LoadConfig() {
		try {
			Yaml yaml = new Yaml();
			if(ConfigUtil.OpenOuterConfig) {
				String path = ConfigUtil.OuterConfigPath + "/hoyi-service.yml";
				byte[] configbts = StreamUtils.Create().ReaderResource(path, path);
				String configcontent = new String(configbts, "UTF-8");
				hoyiconfig = yaml.loadAs(configcontent, HoyiServiceConfig.class);
			}else {
				hoyiconfig = yaml.loadAs(HoyiCloudApplication.class.getResourceAsStream("/config/hoyi-service.yml"),
						HoyiServiceConfig.class);
			}
			if (hoyiconfig == null)
				hoyiconfig = new HoyiServiceConfig();
			Console.Info(hoyiconfig.toString());
		} catch (Exception e) {
			hoyiconfig = new HoyiServiceConfig();
			Console.Info("No Hoyi Cloud Configureation File!");
		}
	}

	public static void Start() {
		Start(REQ_PORT, "./WebContent", new DispatcherServlet());
	}

	public static void Start(int port) {
		Start(port, "./WebContent", new DispatcherServlet());
	}

	public static void Start(int port, String webcontent){

		Start(port, webcontent, new DispatcherServlet());
	}
	/**
	 * 打开外部配置文件，
	 * 提供部署到服务器的时候，不需要暴露用户名密码，
	 * 传输代码到外部服务器时候，不需要泄露更多用户名密码等数据。
	 * 
	 * @param outerconfigpath
	 */
	public static void OpenOutConfig(String outerconfigpath) {
		ConfigUtil.OpenOuterConfig = true;
		ConfigUtil.OuterConfigPath = outerconfigpath;
	}
	
	/**
	 * 打开调试模式，不会缓存文件、HTML，修改的类会动态加载，不会从内存中读取，
	 * 部署的时候，请不要打开这个选项.
	 * @param hotloadpath
	 */
	public static void OpenDebug(String hotloadpath) {
		HoyiCloudApplication.DevelopingMode = true;
		
		Hoyipage.OpenCacheHTML = false;
		HTMLUtils.OpenHTMLCache = false;
		// 关掉页面的Mapping.
//		HOYIConf.PageCache = false;
		HoyiPageDispatcher.HotLoadClass = true;
		CustomClassLoader.basedir = hotloadpath;
	}
	
	/**
	 * 打开自动刷新页面，
	 * 打开后，页面会每个refreshsec秒自动刷新.
	 * @param refreshsec 自动刷新的秒数.
	 */
	public static void OpenAutoRefresh(int refreshsec) {
		HoyiCloudApplication.AutoRefreshSeconds = refreshsec;
		HoyiCloudApplication.AutoRefreshPage = true;
	}
	
	/**
	 * 打开调试模式，不会缓存文件、HTML，修改的类会动态加载，不会从内存中读取
	 * 当前模式对非文件类、非HoyiPage类貌似无效，遇到无效的时候，请重启.
	 * 默认从启动地址的target/classes获取类，
	 * 如果ClassLoader路径不正确，请用其他方法.
	 */
	public static void OpenDebug() {
		String relativelyPath=System.getProperty("user.dir") + "/target/classes/" ;
		HoyiCloudApplication.debugWebRootPath = System.getProperty("user.dir") + "/src/";
		
		OpenDebug(relativelyPath);
	}
	
	/**
	 * 启动服务的Server.
	 */
	private static Server server = null;
	/**
	 * 获取Jetty服务器对象.
	 * @return
	 */
	public static Server getServer() {
		return server;
	}

	public static void Start(int port, String webcontent, Servlet startservlet) {
		HoyiCloudApplication.CloudAppStarting = true;
		LoadConfig();
		NEED_PORT = hoyiconfig.getHOYI().getOrDefault("NEED-PORT", "false");
		// 服务类型
		String SERVICETYPE = hoyiconfig.getSERVICE().getOrDefault("SERVICE-TYPE", "PROVIDER");
		// 调度地址
		String DISPATCHURL = hoyiconfig.getSERVICE().get("DISPATCHER-URL");

		String SERVICEID = hoyiconfig.getSERVICE().get("SERVICE-ID");
		String HOST = hoyiconfig.getHOYI().get("HOST");
		System.out.println("DISPATCHER-URL:" + DISPATCHURL);

		if (NEED_PORT.trim().toUpperCase().equals("TRUE")) {
			// 如果需要由服务器分配端口。
			System.out.println("Get Start ServicePort:" + DISPATCHURL + "index/GetStartPort.html");
			String PORT_BAK = hoyiconfig.getHOYI().get("PORT-BAK");
			HttpRequest request = new HttpRequest();
			String ret;
			try {
				ret = request.sendPost(DISPATCHURL + "index/GetStartPort.html",
						"serviceid=" + SERVICEID + "&host=" + HOST + "&portbaks=" + PORT_BAK);
				Console.Info("ERT:" + ret);
				JSONObject obj = JSONObject.fromObject(ret);
				String sgetport = obj.get("data").toString();

				Console.Info("Register Service:" + ret);
				if (sgetport != null && sgetport.toString().length() > 0) {
					// 服务器分配了端口，开始启动。
					REQ_PORT = Integer.parseInt(sgetport.toString());
				} else {
					Console.Info("未能分配启动端口，关闭服务"); // 这里后续可以做成重新发起申请
					return;
				}
			} catch (UnsupportedEncodingException e) {
				Console.Error("Getstartport error:" + e.getMessage());
			}
		}else {
			if (port == -1) {
				// 读取端口，未配置用默认.
				REQ_PORT = Integer.parseInt(hoyiconfig.getHOYI().getOrDefault("PORT", "8080"));
			}else {
				REQ_PORT = port;
			}
			Console.Info("port:" + REQ_PORT);
		}

		if ("PROVIDER".equals(SERVICETYPE) && DISPATCHURL != null && DISPATCHURL.trim().length() > 1) {
			// 如果是服务提供者，而且调度地址不为空的话，则发起调度注册.
			System.out.println("Register Service URL:" + DISPATCHURL + "index/RegisterService.html");

			HttpRequest request = new HttpRequest();
			try {
				String ret = request.sendPost(DISPATCHURL + "index/RegisterService.html",
						"serviceid=" + SERVICEID + "&host=" + HOST + "&port=" + REQ_PORT);
				Console.Info("Register Service:" + ret);
			} catch (UnsupportedEncodingException e) {
				Console.Info("Register Service:" + e.getMessage());
			}
		}
		try {
			Console.Info("Begin Server:");
			if(webcontent.equals("./WebContent")) {
				// java web项目， 需要webcontent.  需要  ./WebContent
				
				// 完美运行.start
				InetSocketAddress address = new InetSocketAddress(REQ_PORT);
				server = new Server(address);
				WebAppContext webAppContext = new WebAppContext();
				webAppContext.setContextPath("/");
	
				Console.Info("Set Web Content: WebContent:");
				File resDir = new File(webcontent);
				webAppContext.setResourceBase(resDir.getCanonicalPath());
				webAppContext.setConfigurationDiscovered(true);
				webAppContext.setParentLoaderPriority(true);
				server.setHandler(webAppContext);
				Console.Info("Begin Server Finished:");
				server.start();
				server.join();
				// 完美运行.end
			}else {
				// java 非web项目， 不需要webcontent.
				Console.Info("Start Jerry Server.");
				
				InetSocketAddress address = new InetSocketAddress(REQ_PORT);
				server = new Server(address);
				WebAppContext webAppContext = new WebAppContext();
				webAppContext.setContextPath("/");
				webAppContext.setResourceBase(".");
				webAppContext.addServlet(new ServletHolder(startservlet), "/*");
				//webAppContext.addServlet(new ServletHolder(new DispatcherServlet()), "/*");// + HOYIConf.Suffix);
				webAppContext.setConfigurationDiscovered(true);
				webAppContext.setParentLoaderPriority(true);
//				WebAppClassLoader classLoader = new WebAppClassLoader(webAppContext);
//				webAppContext.setClassLoader(classLoader);
				server.setHandler(webAppContext);
				Console.Info("Start Server Finished.");
				
				SessionIniter.getInstance().contextInitialized();
			}
			
			server.start();
			server.join();
		} catch (Exception e) {
			Stop();
		}
	}
	/**
	 * 停止服务器.
	 */
	public static void Stop() {
		Console.Error("Application Closed:");
		try {
			SessionIniter.getInstance().contextDestroyed();
		} catch (Exception e) {
			Console.Error(e);
		}
		try {
			if(server != null) {
				//server.setStopAtShutdown(true);
				server.stop();
			}
		} catch (Exception e1) {
			Console.Error(e1);
		}
	}
	/**
	 * 重启服务.
	 */
	public static void Restart() {
		try {
			Console.Info("Server Restarted");
			WebAppContext context = (WebAppContext)server.getHandler();
	        context.stop();
	        WebAppClassLoader classLoader = new WebAppClassLoader(context);
	        context.setClassLoader(classLoader);
	        context.start();
	        
		} catch (Exception e) {
			Console.Error("Restart Error:" + e.getMessage());
		}
	}

	public static Map<String, List<String>> getPORT_BAKS() {
		return PORT_BAKS;
	}

	public static void setPORT_BAKS(Map<String, List<String>> pORT_BAKS) {
		PORT_BAKS = pORT_BAKS;
	}

	public static Map<String, List<String>> getPORT_USED() {
		return PORT_USED;
	}

	public static void setPORT_USED(Map<String, List<String>> pORT_USED) {
		PORT_USED = pORT_USED;
	}

	/**
	 * 添加可分配的启动端口。
	 * 
	 * @param host
	 * @param port
	 */
	public static void AddBAKPorts(String host, String port) {
		List<String> ps = PORT_BAKS.get(host);
		if (ps != null) {
			ps.add(port);
			PORT_BAKS.remove(host);
			PORT_BAKS.put(host, ps);
		} else {
			ps = new ArrayList<>();
			ps.add(port);
			PORT_BAKS.put(host, ps);
		}
	}

	/**
	 * 将端口从可分配的启动端口列表内移除。
	 * 
	 * @param host
	 * @param port
	 */
	public static void RemoveBakPorts(String host, String port) {
		List<String> ps = PORT_BAKS.get(host);
		if (ps != null && ps.contains(port)) {
			ps.remove(port);
		}
		PORT_BAKS.remove(host);
		PORT_BAKS.put(host, ps);
	}

	/**
	 * 已经使用了的端口，同时需要从PORT_BAK内删掉
	 * 
	 * @param host
	 * @param port
	 */
	public static void UsedPort(String host, String port) {
		List<String> ps = PORT_USED.get(host);
		if (ps != null) {
			ps.add(port);
			PORT_USED.remove(host);
			PORT_USED.put(host, ps);
		} else {
			ps = new ArrayList<>();
			ps.add(port);
			PORT_USED.put(host, ps);
		}
		// 从可分配列表中移除.
		RemoveBakPorts(host, port);
	}
}
