package org.hoyi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import org.hoyi.microservice.HoyiCloudApplication;

/**
 * 文件处理.
 * @author sam
 *
 */
public class StreamUtils {
	
	public static StreamUtils Create() {
		return new StreamUtils();
	}
	/**
	 * 统一文件读取的方法.
	 * @param url
	 * @return
	 */
	public InputStream GotInputStream(String debugurl, String url) {
		try {
			InputStream _inputStream;
			if (HoyiCloudApplication.DevelopingMode) {
				File file = new File(debugurl);
				_inputStream = new FileInputStream(file); // 通过对象多态性，进行实例化
			} else {
				_inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(url);
			}
			return _inputStream;
		} catch (Exception e) {
			return null;
		}
	}
	/**
	 * Resource资源包括target/classes, src/, jar包内等.
	 * @throws Exception 
	 */
	public byte[] ReaderResource(String debugurl, String url) throws Exception {
		InputStream ins = StreamUtils.Create().GotInputStream(debugurl, url);
		byte[] bts = new ByteUtils().readStream(ins);
		return bts;
	}
}
