 package org.hoyi.dispatchs;
 
 import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import org.hoyi.wb.comment.RequestHoyiPage;
import org.hoyi.wb.comment.RequestMethod;
import org.hoyi.wb.comment.RequestService;
 
 /**
  *          Author:ellen
  *          Email:ellen@kuaifish.com
  *          CreateDate:2015-05-20
  *          ModifyDate:2015-06-20
  *          hoyi entities @ hoyi.org
  *          使用请在项目关于内标注hoyi版权，
  *          hoyi版权归hoyi.org所有
  */
 public class DispatchConfig
 {
	   private static DispatchConfig _instance;
	   private ConcurrentHashMap<String, Class<?>> servletMaps = new ConcurrentHashMap();
	 
	   private ConcurrentHashMap<String, Class<?>> hoyipageMaps = new ConcurrentHashMap();
	   
	   public static long beginstarttime = -1;
	   
	   public static long finishstarttime = -1;
	   
	   /**
	    * 是否打开Mapping的输出.
	    */
	   public static boolean ConsoleMapping = false;
	   
	   /**
	    * 是否打开APIDOC的输出.
	    */
	   public static boolean OpenAPIDOC = false;
	   
	   /**
	    * 登录API文档的密码，超过三次输入错误不能登录.
	    */
	   public static String OpenAPIPwds = "";
	   /**
	    * 输入密码次数，超过三次，不允许输入.
	    */
	   public static int OpenAPIPwds_Times = 0;
	 
	   private List<Class<?>> services = new ArrayList();
	 
	   public List<Class<?>> hoyips = new ArrayList();
	 
	   public static DispatchConfig getInstance()
	   {
	     if (_instance == null) {
	       _instance = new DispatchConfig();
	     }
	     return _instance;
	   }
	 
	   public ConcurrentHashMap<String, Class<?>> getServletMaps()
	   {
	     return this.servletMaps;
	   }
	 
	   public ConcurrentHashMap<String, Class<?>> getHoyipageMaps()
	   {
	     return this.hoyipageMaps;
	   }
	 
	   public DispatchConfig()
	   {
	     ConfigHoyiPage();
	     ConfigWebService();
	   }
	 
	   public void ConfigWebService()
	   {
	   }
	 
	   public void ConfigHoyiPage()
	   {
	   }
	 
	   public void PutHoyiPage(Class<?> clas)
	   {
	     if (!this.hoyips.contains(clas)) {
	       this.hoyips.add(clas);
	       if (clas.isAnnotationPresent(RequestHoyiPage.class)) {
	         RequestHoyiPage hoyip = (RequestHoyiPage)clas.getDeclaredAnnotation(RequestHoyiPage.class);
	         this.hoyipageMaps.put(hoyip.url(), clas);
	         System.out.println("------> Reflect HoyiPage:" + clas.toString() + "   to   " + hoyip.url());
	       }
	     } else {
	       System.out.println("------> Reflect HoyiPage:" + clas + " error: no annotation.");
	     }
	   }
	 
	   public void PutService(Class<?> clas)
	   {
	     if (!this.services.contains(clas)) {
	       this.services.add(clas);
	 
	       if (clas.isAnnotationPresent(RequestService.class))
	       {
	         RequestService ses = (RequestService)clas.getDeclaredAnnotation(RequestService.class);
	 
	         Method[] mds = clas.getDeclaredMethods();
	         for (Method method : mds)
	           if (method.isAnnotationPresent(RequestMethod.class)) {
	             RequestMethod rms = (RequestMethod)method.getDeclaredAnnotation(RequestMethod.class);
	 
	             this.servletMaps.put(ses.url() + rms.url(), clas);
	             System.out.println("------> Reflect Class:" + clas.toString() + "   to   " + ses.url() + rms.url());
	           }
	       }
	       else {
	         System.out.println("------> Reflect Class:" + clas + " error: no annotation.");
	       }
	     }
	   }
 }
