package org.hoyi.microservice.api.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.hoyi.microservice.api.anno.ApiPara;

/**
 * 单个API的实体类.
 * 
 * @author sam
 *
 */
public class APIEnti {

	public static AtomicInteger staticid = new AtomicInteger(0);
	
	public  String ID = "";
	
	/**
	 * 模块.
	 */
	public String Module = "";

	/**
	 * 分类,相当于二级模块分类.
	 */
	public String Cates = "";

	/**
	 * 请求的路径
	 */
	public String ReqURL = "";

	/**
	 * POST,GET,DELETE??
	 */
	public String ReqType = "";

	/**
	 * 备注.
	 */
	public String Notes = "";
	
	/**
	 * 接口的所有参数.
	 */
	public List<APIPara> paras;
	
	/**
	 * 返回字段的说明.
	 */
	public List<APIPara> response;
	
	/**
	 * 返回值，有的返回String ,有的返回void, 有的返回JsonModel.
	 */
	public String retValue = "void";
	
	/**
	 * 是否能接受请求
	 */
	public boolean CanReq = false;

	public APIEnti(String _module, String _cates, String _notes, String _requrl, String _reqtype) {
		Init(_module, _cates, _notes, _requrl, _reqtype, new ArrayList<>());
	}

	public APIEnti(String _module, String _cates, String _notes, String _requrl, String _reqtype, List<APIPara> _paras) {
		Init(_module, _cates, _notes, _requrl, _reqtype, _paras);
	}

	public void Init(String _module, String _cates, String _notes, String _requrl, String _reqtype, List<APIPara> _paras) {
		this.Module = _module;
		this.Cates = _cates;
		this.ReqURL = _requrl;
		this.ReqType = _reqtype;
		this.Notes = _notes;
		this.paras = _paras;
		this.ID = String.valueOf(staticid.getAndIncrement());
	}

	public void AddPara(APIPara _para) {
		if (paras == null)
			paras = new ArrayList<>();
		paras.add(_para);
	}
	
	public void AddResponse(APIPara _para) {
		if (response == null)
			response = new ArrayList<>();
		response.add(_para);
	}

}
