/*
 * Decompiled with CFR 0.152.
 */
package org.hoyi.microservice;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import net.sf.json.JSONObject;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.hoyi.DB.ctrl.Console;
import org.hoyi.DB.util.ConfigUtil;
import org.hoyi.ctrls.sys.sh.ShellCtrls;
import org.hoyi.dishop.Hoyipage;
import org.hoyi.dispatchfact.HoyiPageDispatcher;
import org.hoyi.dispatchs.DispatcherServlet;
import org.hoyi.microservice.HoyiServiceConfig;
import org.hoyi.sessionlisten.SessionIniter;
import org.hoyi.util.CustomClassLoader;
import org.hoyi.util.HTMLUtils;
import org.hoyi.util.HttpRequest;
import org.hoyi.util.StreamUtils;
import org.yaml.snakeyaml.Yaml;

public class HoyiCloudApplication {
    public static boolean CloudAppStarting = false;
    public static String debugWebRootPath = "";
    public static boolean DevelopingMode = false;
    public static boolean AutoRefreshPage = false;
    public static int AutoRefreshSeconds = 3;
    public static int REQ_PORT = -1;
    public static String NEED_PORT;
    public static HoyiServiceConfig hoyiconfig;
    private static Map<String, List<String>> PORT_BAKS;
    private static Map<String, List<String>> PORT_USED;
    private static Server server;

    public static void LoadConfig() {
        try {
            Yaml yaml = new Yaml();
            if (ConfigUtil.OpenOuterConfig) {
                String path = ConfigUtil.OuterConfigPath + "/hoyi-service.yml";
                byte[] configbts = StreamUtils.Create().ReaderResource(path, path);
                String configcontent = new String(configbts, "UTF-8");
                hoyiconfig = (HoyiServiceConfig)yaml.loadAs(configcontent, HoyiServiceConfig.class);
            } else {
                hoyiconfig = (HoyiServiceConfig)yaml.loadAs(HoyiCloudApplication.class.getResourceAsStream("/config/hoyi-service.yml"), HoyiServiceConfig.class);
            }
            if (hoyiconfig == null) {
                hoyiconfig = new HoyiServiceConfig();
            }
            Console.Info((String)hoyiconfig.toString());
        }
        catch (Exception e) {
            hoyiconfig = new HoyiServiceConfig();
            Console.Info((String)"No Hoyi Cloud Configureation File!");
        }
    }

    public static void Start() {
        HoyiCloudApplication.Start(REQ_PORT, "./WebContent", (Servlet)new DispatcherServlet());
    }

    public static void Start(int port) {
        HoyiCloudApplication.Start(port, "./WebContent", (Servlet)new DispatcherServlet());
    }

    public static void StopPort(int port) {
        ShellCtrls _shell = new ShellCtrls();
        String result = _shell.StopPort(port);
        Console.Info((String)("port:" + port + " stoped , ret:" + result));
    }

    public static void StopPortIfRunning(int port) {
        ShellCtrls _shell = new ShellCtrls();
        Console.Info((String)("OS NAME:" + _shell.GetOsName()));
        boolean isrunning = _shell.PortisRuning(port);
        if (isrunning) {
            HoyiCloudApplication.StopPort(port);
        }
    }

    public static void Start(int port, String webcontent) {
        HoyiCloudApplication.Start(port, webcontent, (Servlet)new DispatcherServlet());
    }

    public static void OpenOutConfig(String outerconfigpath) {
        ConfigUtil.OpenOuterConfig = true;
        ConfigUtil.OuterConfigPath = outerconfigpath;
    }

    public static void OpenRootConfig() {
        ConfigUtil.Open_HostRoot_Config = true;
    }

    public static void OpenDebug(String hotloadpath) {
        DevelopingMode = true;
        Hoyipage.OpenCacheHTML = false;
        HTMLUtils.OpenHTMLCache = false;
        HoyiPageDispatcher.HotLoadClass = true;
        CustomClassLoader.basedir = hotloadpath;
    }

    public static void OpenAutoRefresh(int refreshsec) {
        AutoRefreshSeconds = refreshsec;
        AutoRefreshPage = true;
    }

    public static void OpenDebug() {
        String relativelyPath = System.getProperty("user.dir") + "/target/classes/";
        debugWebRootPath = System.getProperty("user.dir") + "/src/";
        HoyiCloudApplication.OpenDebug(relativelyPath);
    }

    public static Server getServer() {
        return server;
    }

    public static void Start(int port, String webcontent, Servlet startservlet) {
        CloudAppStarting = true;
        HoyiCloudApplication.LoadConfig();
        NEED_PORT = hoyiconfig.getHOYI().getOrDefault("NEED-PORT", "false");
        String SERVICETYPE = hoyiconfig.getSERVICE().getOrDefault("SERVICE-TYPE", "PROVIDER");
        String DISPATCHURL = hoyiconfig.getSERVICE().get("DISPATCHER-URL");
        String SERVICEID = hoyiconfig.getSERVICE().get("SERVICE-ID");
        String HOST = hoyiconfig.getHOYI().get("HOST");
        System.out.println("DISPATCHER-URL:" + DISPATCHURL);
        if (NEED_PORT.trim().toUpperCase().equals("TRUE")) {
            System.out.println("Get Start ServicePort:" + DISPATCHURL + "index/GetStartPort.html");
            String PORT_BAK = hoyiconfig.getHOYI().get("PORT-BAK");
            HttpRequest request = new HttpRequest();
            try {
                String ret = HttpRequest.sendPost(DISPATCHURL + "index/GetStartPort.html", "serviceid=" + SERVICEID + "&host=" + HOST + "&portbaks=" + PORT_BAK);
                Console.Info((String)("ERT:" + ret));
                JSONObject obj = JSONObject.fromObject((Object)ret);
                String sgetport = obj.get("data").toString();
                Console.Info((String)("Register Service:" + ret));
                if (sgetport == null || sgetport.toString().length() <= 0) {
                    Console.Info((String)"\u672a\u80fd\u5206\u914d\u542f\u52a8\u7aef\u53e3\uff0c\u5173\u95ed\u670d\u52a1");
                    return;
                }
                REQ_PORT = Integer.parseInt(sgetport.toString());
            }
            catch (UnsupportedEncodingException e) {
                Console.Error((String)("Getstartport error:" + e.getMessage()));
            }
        } else {
            REQ_PORT = port == -1 ? Integer.parseInt(hoyiconfig.getHOYI().getOrDefault("PORT", "8080")) : port;
            Console.Info((String)("port:" + REQ_PORT));
        }
        if ("PROVIDER".equals(SERVICETYPE) && DISPATCHURL != null && DISPATCHURL.trim().length() > 1) {
            System.out.println("Register Service URL:" + DISPATCHURL + "index/RegisterService.html");
            HttpRequest request = new HttpRequest();
            try {
                String ret = HttpRequest.sendPost(DISPATCHURL + "index/RegisterService.html", "serviceid=" + SERVICEID + "&host=" + HOST + "&port=" + REQ_PORT);
                Console.Info((String)("Register Service:" + ret));
            }
            catch (UnsupportedEncodingException e) {
                Console.Info((String)("Register Service:" + e.getMessage()));
            }
        }
        try {
            WebAppContext webAppContext;
            InetSocketAddress address;
            Console.Info((String)"Begin Server:");
            if (webcontent.equals("./WebContent")) {
                address = new InetSocketAddress(REQ_PORT);
                server = new Server(address);
                webAppContext = new WebAppContext();
                webAppContext.setContextPath("/");
                Console.Info((String)"Set Web Content: WebContent:");
                File resDir = new File(webcontent);
                webAppContext.setResourceBase(resDir.getCanonicalPath());
                webAppContext.setConfigurationDiscovered(true);
                webAppContext.setParentLoaderPriority(true);
                server.setHandler((Handler)webAppContext);
                Console.Info((String)"Begin Server Finished:");
                server.start();
                server.join();
            } else {
                Console.Info((String)"Start Jerry Server.");
                address = new InetSocketAddress(REQ_PORT);
                server = new Server(address);
                webAppContext = new WebAppContext();
                webAppContext.setContextPath("/");
                webAppContext.setResourceBase(".");
                webAppContext.addServlet(new ServletHolder(startservlet), "/*");
                webAppContext.setConfigurationDiscovered(true);
                webAppContext.setParentLoaderPriority(true);
                server.setHandler((Handler)webAppContext);
                Console.Info((String)"Start Server Finished.");
                Console.Info((String)"websocket Started!~");
                SessionIniter.getInstance().contextInitialized();
            }
            server.start();
            server.join();
        }
        catch (Exception e) {
            HoyiCloudApplication.Stop();
        }
    }

    public static void Stop() {
        Console.Error((String)"Application Closed:");
        try {
            SessionIniter.getInstance().contextDestroyed();
        }
        catch (Exception e) {
            Console.Error((Exception)e);
        }
        try {
            if (server != null) {
                server.stop();
            }
        }
        catch (Exception e1) {
            Console.Error((Exception)e1);
        }
    }

    public static void Restart() {
        try {
            Console.Info((String)"Server Restarted");
            WebAppContext context = (WebAppContext)server.getHandler();
            context.stop();
            WebAppClassLoader classLoader = new WebAppClassLoader((WebAppClassLoader.Context)context);
            context.setClassLoader((ClassLoader)classLoader);
            context.start();
        }
        catch (Exception e) {
            Console.Error((String)("Restart Error:" + e.getMessage()));
        }
    }

    public static Map<String, List<String>> getPORT_BAKS() {
        return PORT_BAKS;
    }

    public static void setPORT_BAKS(Map<String, List<String>> pORT_BAKS) {
        PORT_BAKS = pORT_BAKS;
    }

    public static Map<String, List<String>> getPORT_USED() {
        return PORT_USED;
    }

    public static void setPORT_USED(Map<String, List<String>> pORT_USED) {
        PORT_USED = pORT_USED;
    }

    public static void AddBAKPorts(String host, String port) {
        List<String> ps = PORT_BAKS.get(host);
        if (ps != null) {
            ps.add(port);
            PORT_BAKS.remove(host);
            PORT_BAKS.put(host, ps);
        } else {
            ps = new ArrayList<String>();
            ps.add(port);
            PORT_BAKS.put(host, ps);
        }
    }

    public static void RemoveBakPorts(String host, String port) {
        List<String> ps = PORT_BAKS.get(host);
        if (ps != null && ps.contains(port)) {
            ps.remove(port);
        }
        PORT_BAKS.remove(host);
        PORT_BAKS.put(host, ps);
    }

    public static void UsedPort(String host, String port) {
        List<String> ps = PORT_USED.get(host);
        if (ps != null) {
            ps.add(port);
            PORT_USED.remove(host);
            PORT_USED.put(host, ps);
        } else {
            ps = new ArrayList<String>();
            ps.add(port);
            PORT_USED.put(host, ps);
        }
        HoyiCloudApplication.RemoveBakPorts(host, port);
    }

    static {
        PORT_BAKS = new HashMap<String, List<String>>();
        PORT_USED = new HashMap<String, List<String>>();
        server = null;
    }
}

