package WebRoot.hoyicloud.apidoc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.hoyi.dishop.Hoyipage;
import org.hoyi.dispatchs.DispatchConfig;
import org.hoyi.microservice.api.model.APICons;
import org.hoyi.microservice.api.model.APIEnti;
import org.hoyi.microservice.api.model.APIPara;
import org.hoyi.wb.comment.RequestMode;
import org.hoyi.wb.comment.RequestType;
import org.hoyi.wb.comment.UnApiDoc;

@UnApiDoc
@RequestMode(MODE= {RequestType.GET, RequestType.POST})
public class index extends Hoyipage {
	
	int pgsize = 10;
	
	@Override
	public void OnPreInit() throws IOException {
		if(DispatchConfig.OpenAPIDOC) {
			if(DispatchConfig.OpenAPIPwds.length() == 0 || (getParams("pwds").equals(DispatchConfig.OpenAPIPwds) && DispatchConfig.OpenAPIPwds_Times <= 3)) {
				super.OnPreInit();
			}else {
				DispatchConfig.OpenAPIPwds_Times++;
				this.WriteUTF8HTML("Welcome to Hoyi Cloud.PP!~");
			}
		}else {
			this.WriteUTF8HTML("Welcome to Hoyi Cloud.!~");
		}
	}
	
	public String GetModules() {
		String retobj = "";
		for (Object keys : APICons.getInstance().module_cates.keySet().toArray()) {
			retobj += "<li role=\"presentation\" onclick=\"GetCates('" + keys + "')\"><a >" + keys + "</a></li>";
		}
		return retobj;
	}

	@RequestMode(MODE= {RequestType.GET, RequestType.POST})
	public void GetCates() {
		String module = getParams("module");
		String retobj = "";
		for (Object keys : APICons.getInstance().module_cates.get(module)) {
			retobj += "<li role=\"presentation\"  onclick=\"GetAPIS('" + module + "_" + keys + "','1')\"><a href=\"#\">" + keys + "</a></li>";
		}
		this.WriteUTF8HTML(retobj);
	}

	@RequestMode(MODE= {RequestType.GET, RequestType.POST})
	public void GetAPIS() {
		String filter = getParams("filter");
		String cates = getParams("cates");
		List<APIEnti> apienties = APICons.getInstance().apis.get(cates);
		if(filter != null && filter.length() > 0) {
			apienties = new ArrayList<>();
			for (APIEnti apiEnti : APICons.getInstance().apis.get(cates)) {
				if(apiEnti.ReqURL.contains(filter) || apiEnti.Notes.contains(filter)) {
					apienties.add(apiEnti);
				}
			}
		}
		
		int datacount = apienties.size();
		int pgidx = GetParamsInt("pgidx", 1);
		int startidx = (pgidx - 1) * pgsize;
		int endidx = (pgidx) * pgsize;
		if(endidx>datacount) {
			endidx = datacount;
		}
		apienties = apienties.subList(startidx, endidx);
		
		String retobj = "";
		for (APIEnti apien : apienties) {
			retobj += "<div class=\"panel panel-default\" >" + 
					"		    <div class=\"panel-heading\" onclick=\"showapis(this,'" + cates + "','" + apien.ReqURL + "');\">" + 
					"		      <h4 class=\"panel-title\">" + 
					"		        <a data-toggle=\"collapse\" data-parent=\"#accordion\"" + 
					"		          href=\"#collapse" + apien.Notes + "\">" + 
					"[" + apien.ReqType + "]  " + apien.ReqURL + "   " + apien.Notes +
					"		        </a>" + 
					"		      </h4>" + 
					"		    </div>" + 
					"		    <div  class=\"panel-collapse collapse in\">" + 
//					"		      <div id=\"collapse" + apien.ReqURL + "\" class=\"panel-body\">" + 
//					"		      </div>" + 
					"		    </div>" + 
					"		  </div>";
		}
		int pgcount = datacount / pgsize + (datacount % pgsize > 0 ? 1 : 0);
		String pgs = "";
		for (int i = 1; i < pgcount + 1; i++) {
			pgs += "<li><a href=\"#\" onclick=\"GetAPIS(curcates, "+ i + ")\">"+ i + "</a></li>";
		}
		retobj += "<nav aria-label=\"Page navigation\">" + 
				"					  <ul class=\"pagination\">" + 
					pgs+
				"					  </ul>" + 
				"					</nav>";
		this.WriteUTF8HTML(retobj);
	}
	
	/**
	 * 获取API请求的详细信息，包括可以模拟发送请求。
	 */
	public void GetReqTable() {
		String cates = getParams("cates");
		String requrl = getParams("requrl");
		String tbody = "";
		String respintro = "";
		int i = 1;
		APIEnti curenti = null;
		for (APIEnti enti : APICons.getInstance().apis.get(cates)) {
			if(enti.ReqURL.equals(requrl)) {
				curenti = enti;
				for (APIPara para : enti.paras) {
					tbody+= 
							"        <tr class=\"paras\">" + 
							"          <th scope=\"row\">"+i+"</th>" + 
							"          <td>" + para.Comment + "</td>" + 
							"          <td class=\"name\">" + para.Name + "</td>" + 
							"          <td><input class=\"input\" type=\"text\" /></td>" + 
							"          <td>" + para.CHARType + "</td>" + 
							"          <td>" + para.Required + "</td>" + 
							"        </tr>" ;
					i ++;
				}
				respintro = "";
				if(enti.response != null && enti.response.size() > 0) {
					for (APIPara resp : enti.response) {
						respintro +="<tr><td>"
								+ resp.Name
								+ "</td><td>"
								+resp.Comment
								+ "</td></tr>";
					}
					//Console.Info("RespIntro:" + respintro);
					respintro = "<table class=\"table table-hover\" id=\"tbresp" + curenti.ID + "\" >" +
								"        <tr>" + 
								"          <th>Para Name</th>" + 
								"          <th>Comment</th>" + 
								"        </tr>" + 
								 respintro	+
								"</table>";
					//Console.Info("RespIntro:" + respintro);
				}
			}
		}
		
		
		
		tbody += "<tr><td>Request:</td><td colspan=\"5\" id=\"request" + curenti.ID + "\">" + getRequest().getRequestURL().toString().replace(getRequest().getRequestURI(), "") + "/" + requrl + "</td></tr>";
		tbody += "<tr><td>Parameters:</td><td colspan=\"5\" style=\"max-width: 500px;\" id=\"para" + curenti.ID + "\"></td></tr>";
		tbody += "<tr><td>Parameters.req:</td><td colspan=\"5\" style=\"max-width: 500px;\"  id=\"reqpara" + curenti.ID + "\"></td></tr>";
		
		tbody += "<tr><td></td><td colspan=\"5\"><button class=\"btn btn-success\" onclick=\"req('" + curenti.ID + "')\" >提交</button></td></tr>";
		tbody += "<tr><td>Response:</td><td colspan=\"5\"  style=\"max-width: 500px;\"   id=\"response" + curenti.ID + "\"></td></tr>";

		tbody += "<tr><td>Response.Introduce:</td>"
				+ "<td colspan=\"5\">"
				+respintro+ "</td></tr>";
		tbody += "<tr><td>Canreq:</td><td colspan=\"2\">" + curenti.CanReq + "</td><td>retValue:</td><td colspan=\"2\">" + curenti.retValue + "</td></tr>";
		
		String teb = "<table class=\"table table-hover\" id=\"apitable" + curenti.ID + "\" >" + 
				"      <thead>" + 
				"        <tr>" + 
				"          <th>#</th>" + 
				"          <th>Comment</th>" + 
				"          <th>Para Name</th>" + 
				"          <th>Values</th>" + 
				"          <th>Types</th>" + 
				"          <th>Required</th>" + 
				"        </tr>" + 
				"      </thead>" + 
				"      <tbody id=\"apibody" + curenti.ID +"\">" + 
				tbody	+ 
				"      </tbody>" + 
				"    </table>";
		this.WriteUTF8HTML(teb);
		
	}
	
//	public String GetDOCS() {
//		String ret = "";
//		
//		for (String pgkey : HoyiPageStaticCache.getInstance().hoyipagescache.keySet()) {
//			ret += "<div class=\"panel panel-default\">" + 
//					"		    <div class=\"panel-heading\">" + 
//					"		      <h4 class=\"panel-title\">" + 
//					"		        <a data-toggle=\"collapse\" data-parent=\"#accordion\"" + 
//					"		          href=\"#collapse" + pgkey + "\">" + 
//						pgkey + 
//					"		        </a>" + 
//					"		      </h4>" + 
//					"		    </div>" + 
//					"		    <div id=\"collapse" + pgkey + "\" class=\"panel-collapse collapse in\">" + 
//					"		      <div class=\"panel-body\">" + 
//						HoyiPageStaticCache.getInstance().hoyipagescache.get(pgkey)
//					+ 
//					"		      </div>" + 
//					"		    </div>" + 
//					"		  </div>";
//		}
		
//		ret += "<ul>";
//		for (String creq : HoyiPageStaticCache.getInstance().reqmapping.keySet()) {
//			ret += "<li>" + creq + ":" + HoyiPageStaticCache.getInstance().reqmapping.get(creq) + "</li>";
//		}
//		ret += "</ul>";
		
//		return ret;
//	}
	
}
