package WebRoot.hoyicloud;

import java.io.IOException;
import java.util.List;
import java.util.UUID;

import org.hoyi.dishop.Hoyipage;
import org.hoyi.microservice.HoyiCloudApplication;
import org.hoyi.microservice.HoyiServiceManagement;
import org.hoyi.microservice.configers.nginx.nginxConfExe;
import org.hoyi.microservice.routes.model.HoyiProvider;
import org.hoyi.wb.comment.RequestMode;
import org.hoyi.wb.comment.RequestType;
import org.hoyi.wb.comment.UnApiDoc;

@UnApiDoc
@RequestMode(MODE= {RequestType.POST, RequestType.GET})
public class index extends Hoyipage{
	
	@Override
	public void OnPreInit() throws IOException {
		// 服务类型,如果服务类型是PROVIDER,则不提供调度服务.
		String SERVICETYPE = HoyiCloudApplication.hoyiconfig.getSERVICE().getOrDefault("SERVICE-TYPE", "PROVIDER");
		if(!"PROVIDER".equals(SERVICETYPE)){
			super.OnPreInit();	
		}
	}
	
	@RequestMode(MODE= {RequestType.POST})
	public void RegisterService() {
		String serviceID = this.getParams("serviceid");
		String host = this.getParams("host");
		String port = this.getParams("port");
		
		HoyiProvider service = new HoyiProvider(host, port, serviceID, UUID.randomUUID().toString());
		HoyiServiceManagement.getInstance().getProviders().add(service);
		
		HoyiCloudApplication.UsedPort(host, port);
		nginxConfExe.getInstance().PublishRoute();
		this.WriteUTF8JSONDATAMSG(201, "服务提供注册成功", null);
	}

	@RequestMode(MODE= {RequestType.POST})
	public void GetStartPort() {
		String serviceid = getParams("serviceid");
		String host = getParams("host");
		String portbaks = getParams("portbaks");
		String[] ports = portbaks.replaceAll(" ", "").split(",");
		for (String spo : ports) {
			HoyiCloudApplication.AddBAKPorts(host, spo);
		}
		List<String> canUsedPort = HoyiCloudApplication.getPORT_BAKS().get(host);
		if(canUsedPort != null && canUsedPort.size() > 0) {
			String distriport = canUsedPort.get(0);
			HoyiCloudApplication.RemoveBakPorts(host, distriport);
			this.WriteUTF8JSONDATAMSG(201, "获取启动端口成功", distriport);
		}else {

			this.WriteUTF8JSONDATAMSG(202, "未能找到可分配端口，请自行处理！～", -1);
		}
	}
	
	public String GetServiceInfo() {
		/**
            <tr class="even gradeA">
                <td>Trident</td>
                <td>Internet Explorer 6</td>
                <td>Win 98+</td>
                <td class="center">6</td>
                <td class="center">A</td>
            </tr>
		 */
		String string = "";
		for (HoyiProvider service : HoyiServiceManagement.getInstance().getProviders()) {
			string += "<tr class=\"even gradeA\">\n" + 
"                                        <td>" + service.getHost() + "</td>\n" + 
"                                        <td>"+service.getPort() +"</td>\n" + 
"                                        <td>" + service.getServiceID()+ "</td>\n" + 
"                                        <td class=\"center\">" + service.getServiceUUID() + "</td>\n" + 
"                                        <td class=\"center\"></td>\n" + 
"                                        <td class=\"center\"></td>\n" + 
"                                        <td>"
+ "                         <a class=\"label label-success\" style=\"padding:4px;\">" + 
"					            <span class=\"glyphicon glyphicon-pencil\" style=\"color:white;\" aria-hidden=\"true\"></span>  \n" + 
"						    </a></td>\n" + 
"                      </tr>";
		}
		return string;
	}

}
