/*
 * Decompiled with CFR 0.152.
 */
package org.hoyi.dispatchfact;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hoyi.DB.conf.HOYIConf;
import org.hoyi.DB.ctrl.Console;
import org.hoyi.dispatchfact.IDispatcher;
import org.hoyi.util.StreamUtils;
import org.hoyi.wb.comment.RequestType;

public class CustomFileDispatcher
implements IDispatcher {
    private static Map<String, byte[]> customfilecache = new HashMap<String, byte[]>();
    private static Map<String, String> customfilesuffix = new HashMap<String, String>();

    @Override
    public boolean doSth(HttpServletRequest _request, HttpServletResponse _response, String _requrl, RequestType _reqType) {
        try {
            if (_requrl.endsWith(HOYIConf.Suffix)) {
                return false;
            }
            if (_requrl.trim().length() > 0 && _requrl.contains(".") && !_requrl.toLowerCase().endsWith(".hoyip.html")) {
                String suffix = _requrl.substring(_requrl.lastIndexOf(".") + 1, _requrl.length());
                Console.Info((String)("_requrl:" + _requrl));
                String loadpath = _requrl;
                if (customfilecache.containsKey(_requrl)) {
                    ServletOutputStream outstream = _response.getOutputStream();
                    String contype = customfilesuffix.get(_requrl);
                    _response.setHeader("Content-Type", contype);
                    outstream.write(customfilecache.get(_requrl));
                    outstream.flush();
                    outstream.close();
                    return true;
                }
                loadpath = "WebRoot" + _requrl;
                byte[] bts = StreamUtils.Create().ReaderResource(loadpath);
                String content = new String(bts, "UTF-8");
                ServletOutputStream outstream = _response.getOutputStream();
                String contype = this.GetTypeBySuffix(suffix);
                _response.setHeader("Content-Type", contype);
                outstream.write(bts, 0, bts.length);
                outstream.flush();
                outstream.close();
                customfilecache.put(_requrl, bts);
                customfilesuffix.put(_requrl, contype);
                return true;
            }
        }
        catch (Exception e) {
            Console.Error((String)("---------> NO FILE:" + _requrl));
            customfilecache.put(_requrl, null);
            customfilesuffix.put(_requrl, "text/css");
        }
        return false;
    }

    public String GetTypeBySuffix(String suffix) {
        HashMap<String, String> suffixmap = new HashMap<String, String>();
        suffixmap.put("htm", "text/html; charset=UTF-8");
        suffixmap.put("html", "text/html; charset=UTF-8");
        suffixmap.put("json", "text/json; charset=UTF-8");
        suffixmap.put("text", "text/plain; charset=UTF-8");
        suffixmap.put("js", "application/javascript; charset=UTF-8");
        suffixmap.put("css", "text/css; charset=UTF-8");
        suffixmap.put("ico", "image/x-icon");
        suffixmap.put("jpg", "image/jpg");
        suffixmap.put("png", "image/png");
        suffixmap.put("gif", "image/gif");
        suffixmap.put("word", "application/pdf");
        suffixmap.put("word", "application/msword");
        suffixmap.put("woff2", "application/x-font-woff");
        suffixmap.put("woff", "application/x-font-woff");
        suffixmap.put("ttf", "font/ttf");
        if (suffixmap.containsKey(suffix)) {
            return (String)suffixmap.get(suffix);
        }
        return "text/plain; charset=UTF-8";
    }
}

