package org.hoyi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import org.hoyi.DB.ctrl.Console;

public class FileCtrl {
	
	private static FileCtrl _instance;

	public static FileCtrl instance() {
		if (_instance == null) {
			_instance = new FileCtrl();
		}
		return _instance;
	}
	
	/**
	 * 
	 * @param fileName
	 * @param encode
	 * @param jarfilerun 从Jar包内运行的。
	 * @return value
	 */
	public String readFileByChars(String fileName, String encode, boolean jarfilerun) {
		File file = new File(fileName);
		Reader reader = null;
		String ss = "";
		try {
			if(jarfilerun) {
				InputStream inputStream =  Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
				reader = new InputStreamReader(inputStream, encode);
			}else {
				reader = new InputStreamReader(new FileInputStream(file), encode);
			}
			int tempchar;
			while ((tempchar = reader.read()) != -1) {
				// int tempchar;
				if ((char) tempchar != '\r') {
					ss = ss + (char) tempchar;
				}
			}
			reader.close();
		} catch (Exception e) {
			Console.Error(e);
		}
		return ss;
	}

}